/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Config {
    private File file_;
    private Item firstItem_;
    private String parentKey_ = "";

    public Config() {
        this.parentKey_ = "";
    }

    private Config(String string) {
        this.parentKey_ = string + '.';
    }

    public String get(String string) throws IllegalArgumentException {
        return this.getItemValue(string, true);
    }

    public String get(String string, String string2) {
        String string3 = this.getItemValue(string, false);
        return string3 != null ? string3 : string2;
    }

    public void set(String string, String string2) {
        this.getItem(string, true, false).value = string2;
    }

    public int getInt(String string) throws IllegalArgumentException, NumberFormatException {
        return Integer.parseInt(this.getItemValue(string, true).trim());
    }

    public int getInt(String string, int n) throws NumberFormatException {
        String string2 = this.getItemValue(string, false);
        return string2 != null ? Integer.parseInt(string2.trim()) : n;
    }

    public void setInt(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    public long getLong(String string) throws IllegalArgumentException, NumberFormatException {
        return Long.parseLong(this.getItemValue(string, true).trim());
    }

    public long getLong(String string, long l) throws NumberFormatException {
        String string2 = this.getItemValue(string, false);
        return string2 != null ? Long.parseLong(string2.trim()) : l;
    }

    public void setLong(String string, long l) {
        this.set(string, String.valueOf(l));
    }

    public double getDouble(String string) throws IllegalArgumentException, NumberFormatException {
        return Double.valueOf(this.getItemValue(string, true));
    }

    public double getDouble(String string, double d) throws NumberFormatException {
        String string2 = this.getItemValue(string, false);
        return string2 != null ? Double.valueOf(string2) : d;
    }

    public void setDouble(String string, double d) {
        this.set(string, String.valueOf(d));
    }

    public boolean getBoolean(String string) throws IllegalArgumentException {
        return Boolean.valueOf(this.getItemValue(string, true));
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getItemValue(string, false);
        return string2 != null ? Boolean.valueOf(string2) : bl;
    }

    public void setBoolean(String string, boolean bl) {
        this.set(string, String.valueOf(bl));
    }

    public synchronized Config getSubConfig(String string) {
        return this.getSubConfig(string, false);
    }

    public synchronized Config getSubConfig(String string, boolean bl) {
        Item item = this.getItem(string, bl, true);
        if (item.config == null) {
            item.config = new Config(this.parentKey_ + string);
        }
        return item.config;
    }

    public synchronized Config getSubConfig(String string, Config config) {
        Item item = this.getItem(string, false, false);
        if (item == null) {
            return config;
        }
        if (item.config == null) {
            item.config = new Config(this.parentKey_ + string);
        }
        return item.config;
    }

    public String[] getList(String string, String string2) throws IllegalArgumentException {
        Vector vector = new Vector();
        this.getList(string, string2, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void getList(String string, String string2, Vector vector) {
        String string3 = this.get(string, null);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
    }

    public String[] getItemList(String string) {
        Vector vector = new Vector(1);
        this.getItemList(string, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void getItemList(String string, Vector vector) {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string) || (string2 = this.get(string3, null)) == null) continue;
            vector.addElement(string2);
        }
    }

    public String getPath(String string) throws IllegalArgumentException {
        return this.getPath(string, false, true);
    }

    public String getPath(String string, boolean bl, boolean bl2) throws IllegalArgumentException {
        String string2 = this.get(string);
        char c = string2.charAt(0);
        char c2 = File.separatorChar;
        if (bl && c != c2) {
            string2 = c2 + string2;
        }
        if (!bl && c == c2) {
            string2 = string2.substring(1);
        }
        c = string2.charAt(string2.length() - 1);
        if (bl2 && c != c2) {
            string2 = string2 + c2;
        }
        if (!bl2 && c == c2) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public File getFile(String string) throws IllegalArgumentException {
        return new File(this.get(string));
    }

    public File getFile(String string, File file) {
        String string2 = this.get(string, null);
        return string2 == null ? file : new File(string2);
    }

    public void setFile(String string, File file) {
        this.set(string, file.getAbsolutePath());
    }

    public File getDirectory(String string) throws IllegalArgumentException {
        File file = this.getFile(string);
        if (!file.exists()) {
            throw new IllegalArgumentException("directory " + file + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
        return file;
    }

    private Item getItem(String string, boolean bl, boolean bl2) {
        Item item = this.firstItem_;
        Item item2 = this.firstItem_;
        while (item != null) {
            if (item.key.equals(string)) {
                return item;
            }
            item2 = item;
            item = item.next;
        }
        if (bl) {
            item = new Item(string);
            if (item2 == null) {
                this.firstItem_ = item;
            } else {
                item2.next = item;
            }
        }
        if (item == null && bl2) {
            String string2 = "config key '" + this.parentKey_ + string + "' does not exist";
            if (this.file_ != null) {
                string2 = string2 + " in '" + this.file_ + "'";
            }
            throw new IllegalArgumentException(string2);
        }
        return item;
    }

    private String getItemValue(String string, boolean bl) {
        String string2;
        Item item = this.getItem(string, false, bl);
        String string3 = string2 = item == null ? null : item.value;
        if (string2 == null && bl) {
            String string4 = "config key '" + this.parentKey_ + string + "' has no value";
            if (this.file_ != null) {
                string4 = string4 + " in '" + this.file_ + "'";
            }
            throw new IllegalArgumentException(string4);
        }
        return string2;
    }

    public int size() {
        return this.size(false);
    }

    public int size(boolean bl) {
        int n = 0;
        Item item = this.firstItem_;
        while (item != null) {
            ++n;
            if (bl && item.config != null) {
                n += item.config.size(true);
            }
            item = item.next;
        }
        return n;
    }

    public boolean containsKey(String string) {
        return this.getItem(string, false, false) != null;
    }

    public Object remove(String string) {
        Item item = this.firstItem_;
        Item item2 = null;
        while (item != null) {
            if (item.key.equals(string)) {
                if (item2 == null) {
                    this.firstItem_ = item.next;
                } else {
                    item2.next = item.next;
                }
                return item.value;
            }
            item2 = item;
            item = item.next;
        }
        return null;
    }

    public synchronized Config removeSubConfig(String string) {
        Config config = null;
        Item item = this.getItem(string, false, false);
        if (item != null) {
            config = item.config;
            item.config = null;
        }
        return config;
    }

    public void removeAll() {
        this.firstItem_ = null;
        this.file_ = null;
    }

    public Enumeration keys() {
        return new KeyEnum(this.firstItem_);
    }

    public Enumeration values() {
        return new ValueEnum(this.firstItem_);
    }

    public File getSourceFile() {
        return this.file_;
    }

    public synchronized void read(String string) throws IOException {
        this.read(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read(String string, ClassLoader classLoader) throws IOException {
        InputStream inputStream;
        InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("resource '" + string + "' not found");
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            this.read(bufferedReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read(File file) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            this.read(bufferedReader);
            this.file_ = file;
        }
    }

    public synchronized void read(InputStream inputStream) throws IOException {
        this.read(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public synchronized void read(Reader reader) throws IOException {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.removeAll();
        this.read(bufferedReader, 0, 0);
    }

    private int read(BufferedReader bufferedReader, int n, int n2) throws IOException {
        String string;
        String string2 = null;
        String string3 = null;
        block5: while ((string = bufferedReader.readLine()) != null) {
            ++n2;
            if ((string = string.trim()).length() == 0) continue;
            switch (string.charAt(0)) {
                case '#': {
                    continue block5;
                }
                case '{': {
                    if (string2 == null) {
                        this.throwLineException("'{' unexpected", string, n2);
                    }
                    Config config = this.getSubConfig(string2);
                    n2 = config.read(bufferedReader, n + 1, n2);
                    continue block5;
                }
                case '}': {
                    if (n == 0) {
                        this.throwLineException("'}' unexpected", string, n2);
                    }
                    return n2;
                }
            }
            int n3 = string.indexOf(61);
            if (n3 >= 0) {
                string2 = string.substring(0, n3).trim();
                if (string2.length() == 0) {
                    this.throwLineException("key is null", string, n2);
                }
                string3 = string.substring(n3 + 1).trim();
            } else {
                string2 = string;
                string3 = null;
            }
            this.set(string2, string3);
        }
        if (n > 0) {
            this.throwLineException("expected '}'", string, n2);
        }
        return n2;
    }

    private void throwLineException(String string, String string2, int n) throws IOException {
        throw new IOException(string + ", line='" + string2 + "', lineNumber=" + n);
    }

    public synchronized void write() throws IOException {
        if (this.file_ == null) {
            throw new IOException("not read from a file");
        }
        this.write(this.file_);
    }

    public synchronized void write(String string) throws IOException {
        this.write(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        this.file_ = file;
        try {
            this.write(bufferedWriter);
        }
        finally {
            ((Writer)bufferedWriter).close();
        }
    }

    public synchronized void write(Writer writer) throws IOException {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.write(printWriter, "");
    }

    private void write(PrintWriter printWriter, String string) throws IOException {
        Item item = this.firstItem_;
        while (item != null) {
            if (item.value != null || item.config != null) {
                printWriter.print(string);
                printWriter.print(item.key);
                if (item.value != null) {
                    printWriter.print(" = ");
                    printWriter.print(item.value);
                }
                printWriter.println();
                if (item.config != null) {
                    printWriter.print(string);
                    printWriter.println("{");
                    item.config.write(printWriter, string + '\t');
                    printWriter.print(string);
                    printWriter.println("}");
                }
            }
            item = item.next;
        }
    }

    private static class ValueEnum
    implements Enumeration {
        private Item item_;

        ValueEnum(Item item) {
            this.item_ = item;
        }

        @Override
        public boolean hasMoreElements() {
            return this.item_ != null;
        }

        public Object nextElement() {
            String string = this.item_.value;
            this.item_ = this.item_.next;
            return string;
        }
    }

    private static class KeyEnum
    implements Enumeration {
        private Item item_;

        KeyEnum(Item item) {
            this.item_ = item;
        }

        @Override
        public boolean hasMoreElements() {
            return this.item_ != null;
        }

        public Object nextElement() {
            if (this.item_ == null) {
                throw new NoSuchElementException();
            }
            String string = this.item_.key;
            this.item_ = this.item_.next;
            return string;
        }
    }

    private static class Item {
        private Config config;
        private String value;
        private Item next;
        private final String key;

        public Item(String string) {
            this.key = string;
        }
    }
}

