/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.expr.function;

import jd.xml.util.XmlUtil;
import jd.xml.xpath.XPathContext;
import jd.xml.xpath.expr.function.FunctionType;
import jd.xml.xpath.expr.function.Round;
import jd.xml.xpath.expr.function.StringFunction;

public class Substring
extends StringFunction {
    public static final FunctionType TYPE = new FunctionType("substring", 2, 3);

    @Override
    public FunctionType getFunctionType() {
        return TYPE;
    }

    @Override
    public String toStringValue(XPathContext xPathContext) {
        String string = this.arguments_[0].toStringValue(xPathContext);
        int n = string.length();
        double d = Round.round(this.arguments_[1].toNumberValue(xPathContext));
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            if (d2 >= d) {
                if (this.arguments_.length == 3) {
                    double d3 = d + Round.round(this.arguments_[2].toNumberValue(xPathContext));
                    if (Double.isNaN(d3)) {
                        return "";
                    }
                    for (int j = i; j < n; ++j) {
                        if (d2 >= d3) {
                            return string.substring(i, j);
                        }
                        if (XmlUtil.startsSurrogatePair(string.charAt(j))) {
                            ++j;
                        }
                        d2 += 1.0;
                    }
                }
                return string.substring(i);
            }
            if (XmlUtil.startsSurrogatePair(string.charAt(i))) {
                ++i;
            }
            d2 += 1.0;
        }
        return "";
    }
}

