/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.expr.visitor;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import jd.io.TabWriter;
import jd.xml.xpath.VariableName;
import jd.xml.xpath.axis.Axis;
import jd.xml.xpath.axis.NodeTest;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.ExpressionVisitor;
import jd.xml.xpath.expr.path.SimpleLocationStep;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.Relation;
import jd.xml.xpath.object.XObject;

public class ExprTreeWriter
implements ExpressionVisitor {
    private final TabWriter out_;

    public ExprTreeWriter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public ExprTreeWriter(Writer writer) {
        this.out_ = writer instanceof TabWriter ? (TabWriter)writer : new TabWriter(writer, true);
    }

    public synchronized void print(Expression expression) {
        expression.accept(this);
        this.out_.flush();
    }

    @Override
    public void add(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "+");
    }

    @Override
    public void and(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, " and ");
    }

    @Override
    public void compare(Expression expression, Expression expression2, Equality equality, Expression expression3) {
        this.operator(expression2, expression3, equality.getSymbol());
    }

    @Override
    public void compare(Expression expression, Expression expression2, Relation relation, Expression expression3) {
        this.operator(expression2, expression3, relation.getSymbol());
    }

    @Override
    public void composedPath(Expression expression, Expression expression2, Expression expression3) {
        this.out_.println("[ComposedPath]");
        this.out_.increaseTab();
        expression2.accept(this);
        expression3.accept(this);
        this.out_.decreaseTab();
    }

    @Override
    public void composedPath(Expression expression, Expression[] expressionArray) {
        this.out_.println("[ComposedPath]");
        this.out_.increaseTab();
        for (int i = 0; i < expressionArray.length; ++i) {
            expressionArray[i].accept(this);
        }
        this.out_.decreaseTab();
    }

    @Override
    public void constant(Expression expression, XObject xObject) {
        this.out_.println(xObject.toString());
    }

    @Override
    public void divide(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, " div ");
    }

    @Override
    public void function(Expression expression, String string, Expression[] expressionArray) {
        this.out_.print(string);
        this.out_.print('(');
        if (expressionArray != null) {
            for (int i = 0; i < expressionArray.length; ++i) {
                if (i > 0) {
                    this.out_.print(", ");
                }
                expressionArray[i].accept(this);
            }
        }
        this.out_.print(')');
    }

    @Override
    public void invalid(Expression expression, String string, String string2) {
        this.out_.print(string);
    }

    @Override
    public void locationStep(Expression expression, Axis axis, NodeTest nodeTest) {
        this.out_.print(axis.toString());
        this.out_.print(nodeTest.toString());
        this.out_.println();
    }

    @Override
    public void locationStep(Expression expression, Axis axis, NodeTest nodeTest, Expression expression2, boolean bl, boolean bl2) {
        this.predicate(null, new SimpleLocationStep(axis, nodeTest), expression2, bl);
    }

    @Override
    public void modulo(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, " mod ");
    }

    @Override
    public void multiply(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, " * ");
    }

    @Override
    public void negate(Expression expression, Expression expression2) {
        this.out_.print("-");
        expression2.accept(this);
    }

    private void operator(Expression expression, Expression expression2, String string) {
        this.out_.print("[Operation]");
        this.out_.println(string);
        this.out_.increaseTab();
        expression.accept(this);
        expression2.accept(this);
        this.out_.decreaseTab();
    }

    @Override
    public void or(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, " or ");
    }

    @Override
    public void parenthesis(Expression expression, Expression expression2) {
        this.out_.println("(");
        this.out_.increaseTab();
        expression2.accept(this);
        this.out_.decreaseTab();
        this.out_.println(")");
    }

    @Override
    public void predicate(Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this.out_.println("[Predicate]");
        this.out_.increaseTab();
        expression2.accept(this);
        expression3.accept(this);
        this.out_.decreaseTab();
    }

    @Override
    public void root(Expression expression) {
        this.out_.println("[Root]");
    }

    @Override
    public void subtract(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "-");
    }

    @Override
    public void union(Expression expression, Expression expression2, Expression expression3) {
        this.operator(expression2, expression3, "|");
    }

    @Override
    public void variableReference(Expression expression, VariableName variableName) {
        this.out_.print("$");
        this.out_.print(variableName.getName());
    }
}

