/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.parse;

import jd.xml.util.XmlSource;
import jd.xml.xpath.model.NodeName;
import jd.xml.xpath.model.parse.ParseHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PullParseHandler
extends ParseHandler {
    private String baseUri_;
    private XmlPullParser parser_;
    private EntityResolver entityResolver_;

    public PullParseHandler(Object object) {
        this((XmlPullParser)object);
    }

    public PullParseHandler(XmlPullParser xmlPullParser) {
        this.parser_ = xmlPullParser;
        this.setFeature("http://xmlpull.org/v1/doc/features.html#process-docdecl", true);
        this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
    }

    @Override
    public void setValidating(boolean bl) {
        this.setFeature("http://xmlpull.org/v1/doc/features.html#validation", bl);
    }

    @Override
    public boolean isValidating() {
        return this.parser_.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
    }

    private void setFeature(String string, boolean bl) {
        try {
            this.parser_.setFeature(string, bl);
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver_ = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver_;
    }

    @Override
    public Object getParser() {
        return this.parser_;
    }

    @Override
    protected void parse(XmlSource xmlSource) throws Exception {
        this.baseUri_ = xmlSource.getUri();
        InputSource inputSource = xmlSource.getInputSource();
        if (inputSource.getCharacterStream() != null) {
            this.parser_.setInput(inputSource.getCharacterStream());
        } else if (inputSource.getByteStream() != null) {
            this.parser_.setInput(inputSource.getByteStream(), inputSource.getEncoding());
        } else {
            throw new IllegalStateException("no InputStream available for " + this.baseUri_);
        }
        XmlPullParser xmlPullParser = this.parser_;
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            switch (n) {
                case 2: {
                    this.startElement();
                    break;
                }
                case 3: {
                    this.flushTextNode();
                    this.popPreserveWhitespace();
                    this.modelBuilder_.endElement();
                    break;
                }
                case 4: {
                    this.text_.appendTested(xmlPullParser.getText());
                    break;
                }
                case 7: {
                    this.text_.append(xmlPullParser.getText());
                    break;
                }
                case 9: {
                    this.flushTextNode();
                    this.modelBuilder_.addComment(xmlPullParser.getText());
                    break;
                }
                case 8: {
                    this.addProcessingInstruction();
                }
            }
            n = xmlPullParser.next();
        }
    }

    private void startElement() throws SAXException {
        Object object;
        int n;
        XmlPullParser xmlPullParser = this.parser_;
        this.flushTextNode();
        int n2 = xmlPullParser.getAttributeCount();
        int n3 = 0;
        if (n2 > 0) {
            this.elementInfo_.ensureAttrCapacity(n2);
            for (n = 0; n < n2; ++n) {
                this.elementInfo_.attrValues[n] = null;
                object = xmlPullParser.getAttributeName(n);
                if (((String)object).startsWith("xmlns")) {
                    String string = xmlPullParser.getAttributeValue(n);
                    if (((String)object).length() == 5) {
                        this.modelBuilder_.addNamespaceMapping("", string);
                        this.elementInfo_.attrValues[n] = string;
                        continue;
                    }
                    if (((String)object).charAt(5) == ':') {
                        this.modelBuilder_.addNamespaceMapping(((String)object).substring(6), string);
                        this.elementInfo_.attrValues[n] = string;
                        continue;
                    }
                }
                ++n3;
            }
        }
        this.elementInfo_.setName(this.getNodeName(xmlPullParser.getName(), true));
        if (n3 > 0) {
            n = 0;
            while (this.elementInfo_.attrCount < n3) {
                if (this.elementInfo_.attrValues[n] == null) {
                    object = this.getNodeName(xmlPullParser.getAttributeName(n), false);
                    this.elementInfo_.addAttribute((NodeName)object, xmlPullParser.getAttributeValue(n), xmlPullParser.getAttributeType(n));
                }
                ++n;
            }
        }
        this.modelBuilder_.startElement(this.elementInfo_);
        this.pushPreserveWhitespace(this.elementInfo_.preserveSpace);
    }

    private void addProcessingInstruction() {
        this.flushTextNode();
        String string = this.parser_.getText();
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            this.modelBuilder_.addProcessingInstruction(string.substring(0, i), string.substring(i + 1).trim());
            return;
        }
        this.modelBuilder_.addProcessingInstruction(string, "");
    }

    @Override
    public int getLineNumber() {
        return this.parser_.getLineNumber();
    }
}

