/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.parse;

import jd.xml.util.SaxUtil;
import jd.xml.util.XmlSource;
import jd.xml.xpath.model.NodeName;
import jd.xml.xpath.model.parse.SaxParseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class Sax2ParseHandler
extends SaxParseHandler
implements ContentHandler,
LexicalHandler {
    private XMLReader xmlReader_;
    private boolean isInDTD_;

    protected Sax2ParseHandler() {
    }

    public Sax2ParseHandler(XMLReader xMLReader) throws SAXException {
        this.xmlReader_ = xMLReader;
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        xMLReader.setContentHandler(this);
        xMLReader.setDTDHandler(this);
        SaxUtil.setProperty(xMLReader, "http://xml.org/sax/properties/lexical-handler", this);
    }

    @Override
    public Object getParser() {
        return this.xmlReader_;
    }

    @Override
    public void setValidating(boolean bl) {
        SaxUtil.setValidating(this.xmlReader_, bl);
    }

    @Override
    public boolean isValidating() {
        return SaxUtil.isValidating(this.xmlReader_);
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        try {
            this.xmlReader_.setEntityResolver(entityResolver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.xmlReader_.getEntityResolver();
    }

    @Override
    protected void parse(XmlSource xmlSource) throws Exception {
        this.isInDTD_ = false;
        this.xmlReader_.parse(this.getInputSource(xmlSource));
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        this.modelBuilder_.addNamespaceMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.flushTextNode();
        this.elementInfo_.setName(this.getNodeName(string, string2, string3));
        int n = attributes.getLength();
        if (n > 0) {
            this.elementInfo_.ensureAttrCapacity(n);
            for (int i = 0; i < n; ++i) {
                NodeName nodeName = this.getNodeName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
                this.elementInfo_.addAttribute(nodeName, attributes.getValue(i), attributes.getType(i));
            }
        }
        this.modelBuilder_.startElement(this.elementInfo_);
        this.pushPreserveWhitespace(this.elementInfo_.preserveSpace);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushTextNode();
        this.popPreserveWhitespace();
        this.modelBuilder_.endElement();
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.isInDTD_) {
            this.flushTextNode();
            this.modelBuilder_.addProcessingInstruction(string, string2);
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        this.isInDTD_ = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.isInDTD_ = false;
    }

    @Override
    public void startEntity(String string) {
    }

    @Override
    public void endEntity(String string) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.isInDTD_) {
            this.flushTextNode();
            this.modelBuilder_.addComment(new String(cArray, n, n2));
        }
    }
}

