/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.visit;

import jd.xml.util.XmlWriter;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xpath.model.NodeVisitor;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.XPathRootNode;

public class Serializer
implements NodeVisitor {
    private XmlWriter out_;

    public Serializer(XmlWriter xmlWriter) {
        this.out_ = xmlWriter;
    }

    public void write(XPathNode xPathNode) {
        xPathNode.accept(this);
        this.out_.flush();
    }

    @Override
    public void root(XPathRootNode xPathRootNode) {
        this.out_.print("<?xml version=\"1.0\" encoding=\"");
        this.out_.print(this.out_.getEncoding().getName());
        this.out_.println("\"?>");
        this.writeChildren(xPathRootNode.getFirstChild());
    }

    @Override
    public void element(XPathNode xPathNode) {
        XPathNode xPathNode2;
        this.out_.print('<');
        this.out_.print(xPathNode.getName());
        for (NamespaceContext namespaceContext = xPathNode.getNamespaceContext(); namespaceContext != null && namespaceContext.getDeclarationId() == xPathNode.getLocalId(); namespaceContext = namespaceContext.next()) {
            this.out_.print(' ');
            if (namespaceContext.getPrefix().length() == 0) {
                this.out_.print("xmlns");
            } else {
                this.out_.print("xmlns:");
                this.out_.print(namespaceContext.getPrefix());
            }
            this.out_.print("=\"");
            this.out_.print(namespaceContext.getUri());
            this.out_.print("\"");
        }
        XPathNode[] xPathNodeArray = xPathNode.getAttributes();
        if (xPathNodeArray != null) {
            for (int i = 0; i < xPathNodeArray.length; ++i) {
                this.out_.printAttribute(xPathNodeArray[i].getName(), xPathNodeArray[i].getValue());
            }
        }
        if ((xPathNode2 = xPathNode.getFirstChild()) == null) {
            this.out_.print("/>");
        } else {
            this.out_.print('>');
            this.out_.increaseTab();
            this.out_.flush();
            this.writeChildren(xPathNode2);
            this.out_.decreaseTab();
            this.out_.print("</");
            this.out_.print(xPathNode.getName());
            this.out_.print('>');
        }
    }

    @Override
    public void text(XPathNode xPathNode) {
        this.out_.printText(xPathNode.getValue());
    }

    @Override
    public void processingInstruction(XPathNode xPathNode) {
        this.out_.print("<?");
        this.out_.print(xPathNode.getName());
        this.out_.print(' ');
        this.out_.print(xPathNode.getValue());
        this.out_.print("?>");
    }

    @Override
    public void comment(XPathNode xPathNode) {
        this.out_.print("<!--");
        this.out_.print(xPathNode.getValue());
        this.out_.print("-->");
    }

    @Override
    public void attribute(XPathNode xPathNode) {
    }

    @Override
    public void namespace(XPathNode xPathNode) {
    }

    private void writeChildren(XPathNode xPathNode) {
        while (xPathNode != null) {
            xPathNode.accept(this);
            xPathNode = xPathNode.getNextSibling();
        }
    }
}

