/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.object;

import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.XNumber;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XString;

public class XBoolean
extends XObject {
    public static final XBoolean TRUE = new XBoolean(true);
    public static final XBoolean FALSE = new XBoolean(false);
    private boolean value_;

    public static XBoolean getBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    private XBoolean(boolean bl) {
        this.value_ = bl;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public Object toValue() {
        return this.value_ ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object toValue(Class clazz) {
        if (XObject.class.isAssignableFrom(clazz)) {
            return this;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Object.class) {
            return this.toValue();
        }
        if (clazz == String.class) {
            return this.toStringValue();
        }
        return XNumber.toNumberValue(this.toNumberValue(), clazz);
    }

    @Override
    public int canConvertTo(Class clazz) {
        if (XObject.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if (clazz == Boolean.TYPE) {
            return 5;
        }
        if (clazz == Boolean.class) {
            return 4;
        }
        if (clazz == Object.class) {
            return 3;
        }
        if (clazz == Double.TYPE || clazz == Float.TYPE || clazz == Long.TYPE || clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
            return 2;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean toBooleanValue() {
        return this.value_;
    }

    @Override
    public double toNumberValue() {
        return this.value_ ? 1.0 : 0.0;
    }

    public static double toNumberValue(boolean bl) {
        return bl ? 1.0 : 0.0;
    }

    @Override
    public String toStringValue() {
        return XBoolean.toStringValue(this.value_);
    }

    public static String toStringValue(boolean bl) {
        return bl ? "true" : "false";
    }

    @Override
    public boolean compare(Equality equality, String string) {
        return equality.compare(this.value_, XString.toBooleanValue(string));
    }

    @Override
    public boolean compare(Equality equality, double d) {
        return equality.compare(this.value_, this.toBooleanValue());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof XBoolean)) {
            return false;
        }
        return this.value_ == ((XBoolean)object).value_;
    }
}

