/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.object;

import jd.xml.xpath.XPathException;
import jd.xml.xpath.model.NodeComparator;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.object.XMutableNodeSet;
import jd.xml.xpath.object.XNodeSet;

public final class XListNodeSet
extends XMutableNodeSet {
    private static final int DEFAULT_CAPACITY = 8;
    private XPathNode firstNode_;
    private XPathNode[] nodes_;
    private int size_;
    private int capacity_;
    private int ordering_;

    public XListNodeSet(int n, int n2) {
        this.ordering_ = n;
        if (n2 > 0) {
            this.ensureCapacity(n2);
        }
    }

    private void ensureCapacity(int n) {
        if (this.nodes_ == null) {
            this.nodes_ = new XPathNode[Math.max(8, n + this.size_)];
            this.nodes_[0] = this.firstNode_;
        } else {
            XPathNode[] xPathNodeArray = this.nodes_;
            int n2 = this.nodes_.length;
            int n3 = n2 * 2;
            if (n2 + n > n3) {
                n3 = n2 + n;
            }
            this.nodes_ = new XPathNode[n3];
            System.arraycopy(xPathNodeArray, 0, this.nodes_, 0, this.size_);
        }
        this.capacity_ = this.nodes_.length;
    }

    @Override
    public int getOrdering() {
        return this.ordering_;
    }

    @Override
    public int size() {
        return this.size_;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public XPathNode getNode(int n) {
        return n == 0 ? this.firstNode_ : this.nodes_[n];
    }

    @Override
    public void addNode(XPathNode xPathNode) {
        if (xPathNode == null) {
            throw new XPathException("node is null");
        }
        if (this.size_ == 0) {
            this.firstNode_ = xPathNode;
            ++this.size_;
            if (this.nodes_ != null) {
                this.nodes_[0] = xPathNode;
            }
        } else {
            if (this.size_ >= this.capacity_) {
                this.ensureCapacity(1);
            }
            this.nodes_[this.size_++] = xPathNode;
        }
    }

    @Override
    public void addNodes(XNodeSet xNodeSet) {
        int n = xNodeSet.size();
        if (n > 1) {
            if (this.size_ + n > this.capacity_) {
                this.ensureCapacity(n);
            }
            if (this.size_ == 0) {
                this.firstNode_ = xNodeSet.getNode(0);
            }
            for (int i = 0; i < n; ++i) {
                this.nodes_[this.size_++] = xNodeSet.getNode(i);
            }
        } else if (n == 1) {
            this.addNode(xNodeSet.getNode(0));
        }
    }

    @Override
    public void sort() {
        if (this.size() > 1) {
            NodeComparator.INSTANCE.sort(this.nodes_, this.size_);
            this.firstNode_ = this.nodes_[0];
        }
        this.ordering_ = 0;
    }
}

