/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt;

import java.io.IOException;
import java.util.Hashtable;
import jd.xml.util.XmlSource;
import jd.xml.xpath.XPathException;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.object.XBoolean;
import jd.xml.xpath.object.XNumber;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XSingleNodeSet;
import jd.xml.xpath.object.XString;
import jd.xml.xslt.MessageListener;
import jd.xml.xslt.Transformation;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.XsltSecurityManager;
import jd.xml.xslt.extension.XExternalObject;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.pipe.Dom2ResultPipe;
import jd.xml.xslt.util.VerboseLog;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractStylesheet
extends Transformation {
    protected Hashtable keys_;
    protected Hashtable decimalFormatSymbols_;
    protected MessageListener messageListener_;
    protected NodeNamePool nodeNamePool_;
    protected VerboseLog verboseLog_;
    protected int warningLevel_ = 1;
    protected XsltSecurityManager securityManager_ = XsltSecurityManager.getGlobalInstance();
    protected OutputFormat outputFormat_ = new OutputFormat();

    private void checkSetup() {
        if (!this.isSetup()) {
            throw new XsltException("stylesheet is not initialized");
        }
    }

    protected abstract boolean isSetup();

    @Override
    public void setWarningLevel(int n) {
        if (n < 0 || this.warningLevel_ > 2) {
            throw new IllegalArgumentException("illegal warning level: " + n);
        }
        this.warningLevel_ = n;
    }

    @Override
    public void setVerboseLog(VerboseLog verboseLog) {
        this.verboseLog_ = verboseLog;
    }

    @Override
    public void setMessageListener(MessageListener messageListener) {
        this.messageListener_ = messageListener;
    }

    @Override
    public boolean setParameter(String string, Object object) {
        XObject xObject;
        this.checkSetup();
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (object == null) {
            xObject = null;
        } else if (object instanceof String) {
            xObject = new XString((String)object);
        } else if (object instanceof Number) {
            xObject = new XNumber(((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            xObject = XBoolean.getBoolean((Boolean)object);
        } else if (object instanceof XObject) {
            xObject = (XObject)object;
        } else if (object instanceof Node) {
            XPathRootNode xPathRootNode = Dom2ResultPipe.getRoot("", (Node)object, this.getNodeNamePool());
            xObject = new XSingleNodeSet(xPathRootNode);
        } else {
            xObject = new XExternalObject(object);
        }
        return this.setParameterInternal(string, xObject);
    }

    public boolean setParameter(String string, String string2, Object object) {
        return this.setParameter(string + ':' + string2, object);
    }

    protected abstract boolean setParameterInternal(String var1, XObject var2);

    @Override
    public OutputFormat getOutputFormat() {
        return this.outputFormat_;
    }

    @Override
    public void setSecurityManager(XsltSecurityManager xsltSecurityManager) {
        if (xsltSecurityManager == null) {
            xsltSecurityManager = XsltSecurityManager.DEFAULT;
        }
        this.securityManager_.checkReplace(xsltSecurityManager);
        this.securityManager_ = xsltSecurityManager;
    }

    @Override
    public NodeNamePool getNodeNamePool() {
        return new NodeNamePool(this.nodeNamePool_);
    }

    @Override
    public void transform(XmlSource xmlSource, XsltResult xsltResult, int n) throws SAXException, IOException, XsltException {
        this.checkSetup();
        try {
            this.transformInternal(xmlSource, xsltResult, n);
        }
        catch (XsltException xsltException) {
            Throwable throwable = xsltException.getException();
            if (throwable != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof SAXException) {
                    throw (SAXException)throwable;
                }
            }
            throw xsltException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (XPathException xPathException) {
            throw new XsltException("xpath exception", xPathException);
        }
        catch (Exception exception) {
            throw new XsltException("xslt exception", exception);
        }
    }

    protected abstract void transformInternal(XmlSource var1, XsltResult var2, int var3) throws Exception;
}

