/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result;

import jd.util.TextBuffer;
import jd.xml.util.XmlUtil;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.NamespaceSupport;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.result.ResultLevel;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SaxResultBuilder
extends ResultBuilder {
    private NamespaceSupport nsSupport_;
    private ContentHandler contentHandler_;
    private LexicalHandler lexicalHandler_;
    private TextBuffer text_ = new TextBuffer();
    private SaxLevel level_;
    private boolean elementStarted_;
    private AttributesImpl attributes_ = new AttributesImpl();

    public SaxResultBuilder(String string, ContentHandler contentHandler) {
        this(string, contentHandler, null);
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler_ = (LexicalHandler)((Object)contentHandler);
        }
    }

    public SaxResultBuilder(String string, ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        super(string);
        if (contentHandler == null) {
            throw new IllegalArgumentException("ContentHandler is null");
        }
        this.contentHandler_ = contentHandler;
        this.lexicalHandler_ = lexicalHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler_;
    }

    @Override
    public void startDocument(OutputFormat outputFormat) {
        try {
            this.level_ = new SaxLevel();
            this.level_.level = -1;
            this.nsSupport_ = new NamespaceSupport();
            this.contentHandler_.startDocument();
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    @Override
    public void endDocument() throws XsltException {
        try {
            this.flush();
            this.contentHandler_.endDocument();
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    @Override
    public void startElement(String string, String string2, NamespaceContext namespaceContext, boolean bl) {
        this.flush();
        this.elementStarted_ = true;
        this.nsSupport_.startElement(string, namespaceContext, this.level_.namespaceContext);
        this.level_ = (SaxLevel)this.level_.increase();
        this.level_.qName = string2;
        this.level_.localName = string != null ? XmlUtil.getLocalPart(string2) : string2;
        this.level_.namespaceUri = string;
        this.level_.namespaceContext = namespaceContext;
        this.level_.isCDataSectionElement = this.lexicalHandler_ != null ? bl : false;
        this.level_.disableEscaping = false;
    }

    @Override
    public void endElement() throws XsltException {
        try {
            this.flush();
            this.contentHandler_.endElement(this.level_.namespaceUri != null ? this.level_.namespaceUri : "", this.level_.localName, this.level_.qName);
            this.nsSupport_.endElement();
            NamespaceSupport.Declaration declaration = this.level_.nsDeclarations_;
            while (declaration != null) {
                this.contentHandler_.endPrefixMapping(declaration.prefix);
                declaration = declaration.next;
            }
            this.level_ = (SaxLevel)this.level_.decrease();
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    @Override
    public void addNamespace(String string, String string2, boolean bl) {
        if (bl) {
            if (!this.elementStarted_) {
                return;
            }
            if (this.attributes_.getLength() != 0) {
                return;
            }
        }
        this.nsSupport_.addDeclaration(string, string2, !bl);
    }

    @Override
    public String getNamespacePrefix(String string) {
        return this.nsSupport_.getPrefix(string);
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4) throws XsltException {
        if (!this.elementStarted_) {
            throw new XsltException("cannot add attribute " + string + "='" + string4 + "' (no element open)");
        }
        if (string3 != null) {
            string = this.nsSupport_.adjustAttributeName(string, string2, string3);
        } else {
            string3 = "";
        }
        int n = this.attributes_.getIndex(string);
        if (n != -1) {
            this.attributes_.setValue(n, string4);
        } else {
            String string5 = string;
            int n2 = string.indexOf(58);
            if (n2 != -1) {
                string5 = string.substring(n2 + 1);
            }
            this.attributes_.addAttribute(string3, string5, string, "CDATA", string4);
        }
    }

    @Override
    public void addText(String string) {
        try {
            if (string.length() > 0) {
                if (this.elementStarted_) {
                    this.flushElement();
                }
                this.text_.append(string);
            }
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    @Override
    public void addTextUnescaped(String string) {
        this.flush();
        this.level_.disableEscaping = true;
        this.addText(string);
        this.flush();
        this.level_.disableEscaping = false;
    }

    @Override
    public void addComment(String string) throws XsltException {
        if (this.lexicalHandler_ != null) {
            try {
                this.flush();
                int n = string.length();
                char[] cArray = new char[n];
                string.getChars(0, n, cArray, 0);
                this.lexicalHandler_.comment(cArray, 0, n);
            }
            catch (Exception exception) {
                this.convertException(exception);
            }
        }
    }

    @Override
    public void addProcessingInstruction(String string, String string2) throws XsltException {
        try {
            this.flush();
            this.contentHandler_.processingInstruction(string, string2);
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    private void flush() {
        if (this.elementStarted_) {
            this.flushElement();
        }
        if (this.text_.length() > 0) {
            this.flushText();
        }
    }

    private void flushText() {
        if (this.text_.length() > 0) {
            try {
                if (this.lexicalHandler_ != null && this.level_.isCDataSectionElement) {
                    this.lexicalHandler_.startCDATA();
                    if (this.lexicalHandler_ != null) {
                        this.flushLexicalText(this.text_.getBuffer(), 0, this.text_.length());
                    } else {
                        this.contentHandler_.characters(this.text_.getBuffer(), 0, this.text_.length());
                    }
                    this.lexicalHandler_.endCDATA();
                } else if (this.lexicalHandler_ != null && !this.level_.disableEscaping) {
                    this.flushLexicalText(this.text_.getBuffer(), 0, this.text_.length());
                } else {
                    this.contentHandler_.characters(this.text_.getBuffer(), 0, this.text_.length());
                }
                this.text_.clear();
            }
            catch (Exception exception) {
                this.convertException(exception);
            }
        }
    }

    private void flushLexicalText(char[] cArray, int n, int n2) {
        try {
            int n3 = n + n2;
            int n4 = 0;
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5 + n4];
                while (c != '<' && c != '>' && c != '&' && n5 + ++n4 != n3) {
                    c = cArray[n5 + n4];
                }
                if (n4 > 0) {
                    this.contentHandler_.characters(cArray, n5, n4);
                }
                if ((n5 += n4) != n3) {
                    if (c == '<') {
                        this.lexicalHandler_.startEntity("lt");
                        this.contentHandler_.characters(cArray, n5, 1);
                        this.lexicalHandler_.endEntity("lt");
                    } else if (c == '>') {
                        this.lexicalHandler_.startEntity("gt");
                        this.contentHandler_.characters(cArray, n5, 1);
                        this.lexicalHandler_.endEntity("gt");
                    } else if (c == '&') {
                        this.lexicalHandler_.startEntity("amp");
                        this.contentHandler_.characters(cArray, n5, 1);
                        this.lexicalHandler_.endEntity("amp");
                    } else {
                        this.contentHandler_.characters(cArray, n5, 1);
                    }
                    ++n5;
                }
                n4 = 0;
            }
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    private void flushElement() {
        if (this.elementStarted_) {
            try {
                NamespaceSupport.Declaration declaration = this.level_.nsDeclarations_ = this.nsSupport_.getElementDeclarations();
                while (declaration != null) {
                    this.contentHandler_.startPrefixMapping(declaration.prefix, declaration.uri);
                    declaration = declaration.next;
                }
                this.elementStarted_ = false;
                this.contentHandler_.startElement(this.level_.namespaceUri != null ? this.level_.namespaceUri : "", this.level_.localName, this.level_.qName, this.attributes_);
                this.attributes_.clear();
            }
            catch (Exception exception) {
                this.convertException(exception);
            }
        }
    }

    private static class SaxLevel
    extends ResultLevel {
        NamespaceContext namespaceContext;
        String namespaceUri;
        String localName;
        String qName;
        boolean isCDataSectionElement;
        boolean disableEscaping;
        NamespaceSupport.Declaration nsDeclarations_;

        private SaxLevel() {
        }

        @Override
        public ResultLevel create() {
            return new SaxLevel();
        }
    }
}

