/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js.impl;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventID;
import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.JobDefinition;
import com.cognos.developer.schemas.bibus._3.JobOptionBoolean;
import com.cognos.developer.schemas.bibus._3.JobOptionEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.js.JSCategory;
import com.cognos.js.api.IHasTaskRunSpec;
import com.cognos.js.api.IJob;
import com.cognos.js.api.JobServiceException;
import com.cognos.js.impl.JobBuilder;
import com.cognos.js.impl.JobHistory;
import com.cognos.js.impl.JobServiceUtil;
import com.cognos.js.impl.StepDefinition;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.IAuthenticator;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.LogJobCmdSpec;
import com.cognos.jsmcommon.util.OptionUtils;

public class Job
implements IJob {
    private static final String RUN_SEQUENTIAL = "sequential";
    private JobDefinition m_definition;
    private JobBiBusHeaders m_headers;
    private IJob[] m_steps;
    private Option[] m_allOptions;
    private ParameterValue[] m_params;
    private String m_eventID;
    private JobHistory m_history;
    private EventStatus m_currentStatus = EventStatus.PENDING;
    private boolean m_cancelled = false;
    private String m_cancellingUser = null;

    public Job(JobDefinition definition, JobBiBusHeaders headers, ParameterValue[] rtParams, Option[] rtOptions) throws JobServiceException {
        this.m_definition = definition;
        this.m_headers = headers;
        this.m_steps = null;
        this.m_allOptions = rtOptions;
        if (this.m_allOptions == null) {
            this.m_allOptions = new Option[]{OptionUtils.getRunOptionsSeparatorOption()};
        } else if (OptionUtils.idxRunOptionsSeparator((Option[])this.m_allOptions) >= this.m_allOptions.length) {
            this.m_allOptions = OptionUtils.concatenateOptions((Option[])this.m_allOptions, (Option[])new Option[]{OptionUtils.getRunOptionsSeparatorOption()});
        }
        if (this.m_definition.getOptions() != null) {
            this.m_allOptions = OptionUtils.mergeOptions((Option[])this.m_allOptions, (Option[])this.m_definition.getOptions().getValue());
        }
        this.m_params = JobServiceUtil.mergeParameters(rtParams, this.m_definition.getParameters().getValue());
        AsynchOptionStringArray contextIDs = (AsynchOptionStringArray)OptionUtils.findFirstOptionWithNameEnum((Option[])this.m_allOptions, (Object)AsynchOptionEnum.runContext);
        this.m_eventID = contextIDs.getValue()[contextIDs.getValue().length - 1];
        AsynchOption historyLocation = (AsynchOption)OptionUtils.findFirstOptionWithNameEnum((Option[])this.m_allOptions, (Object)AsynchOptionEnum.historyLocation);
        boolean writeTrusted = !AuthenticatorFactory.getInstance().hasPermission((BaseClass)definition, "write");
        this.m_history = historyLocation != null ? new JobHistory(historyLocation, headers, writeTrusted) : new JobHistory(this.m_eventID, headers);
        this.updateStatus(EventStatus.PENDING);
    }

    @Override
    public AsynchReply run() throws JobServiceException {
        AsynchReply reply = this.buildReply();
        try {
            if (this.getStatus().isEqualTo(EventStatus.CANCELLED)) {
                this.m_history.addDetail(SeverityEnum.info, EventStatus.PURGED, I18NCode.MSG_JOB_STEP_PURGED);
                reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
                AsynchReply asynchReply = reply;
                return asynchReply;
            }
            this.setSteps(JobBuilder.getStepDefinitions(this.m_definition, this.m_headers, this.m_params, this.getAllOptions(), this.getTenantID()));
            this.m_history.logRuntime(this.getAllOptions(), this.getParams());
            String sequencingString = this.m_definition.getSequencing().getValue();
            if (this.m_steps.length > 0) {
                if (this.m_steps.length == 1 || sequencingString.equals(RUN_SEQUENTIAL)) {
                    this.executeSteps(true);
                } else {
                    this.executeSteps(false);
                }
            }
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Error executing Job with path [" + this.m_definition.getSearchPath().toString() + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.ERROR, e);
            if (e instanceof JobServiceException) {
                throw (JobServiceException)((Object)e);
            }
            throw new JobServiceException(I18NCode.JS_EXECUTE_ERROR, e);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Security Error executing Job with path [" + this.m_definition.getSearchPath().toString() + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).debug(e.getLocalizedMessage());
            throw new JobServiceException(I18NCode.JS_EXECUTE_ERROR, e);
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Throwable Error executing Job with path [" + this.m_definition.getSearchPath().toString() + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).debug(e.getLocalizedMessage());
            throw new JobServiceException(I18NCode.JS_EXECUTE_ERROR, e);
        }
        finally {
            reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        }
        if (this.isCancelled()) {
            if (this.m_cancellingUser != null) {
                throw new JobServiceException(I18NCode.MSG_JOB_WAS_CANCELLED_BY_USER_X, new String[]{this.m_cancellingUser});
            }
            throw new JobServiceException(I18NCode.MSG_CANCELLED_JOB);
        }
        return reply;
    }

    private String getTenantID() {
        IAuthenticator authenticator = AuthenticatorFactory.getInstance();
        String tenantID = "";
        try {
            tenantID = authenticator.getTenantID(this.m_headers.getBiBusHeader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tenantID;
    }

    @Override
    public String getID() {
        return this.m_eventID;
    }

    @Override
    public synchronized void cancel(String user) {
        try {
            this.m_cancelled = true;
            this.m_cancellingUser = user;
            for (int i = 0; i < this.m_steps.length; ++i) {
                this.m_steps[i].cancel(user);
            }
            this.updateStatus(EventStatus.CANCELLED);
            if (user != null) {
                this.m_history.addDetail(SeverityEnum.info, EventStatus.CANCELLED, I18NCode.MSG_JOB_WAS_CANCELLED_BY_USER_X, new String[]{user});
            } else {
                this.m_history.addDetail(SeverityEnum.info, EventStatus.CANCELLED, I18NCode.MSG_CANCELLED_JOB);
            }
        }
        catch (JobServiceException e) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Encountered Error when cancelling a Job.");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
        }
    }

    @Override
    public synchronized EventStatus getStatus() {
        return this.m_currentStatus;
    }

    public void setSteps(IJob[] steps) {
        this.m_steps = steps;
    }

    public AsynchReply buildReply() {
        AsynchReply reply = new AsynchReply();
        AsynchRequest request = new AsynchRequest();
        AsynchDetailEventID dei = new AsynchDetailEventID();
        dei.setEventID(this.m_eventID);
        reply.setDetails(new AsynchDetail[]{dei});
        request.setParameters(this.m_params);
        request.setOptions(this.m_allOptions);
        reply.setPrimaryRequest(request);
        return reply;
    }

    private void executeSteps(boolean inSequence) throws JobServiceException {
        boolean continueOnError = this.getContinueOnError();
        TaskPersistLayerException firstJSE = null;
        TaskPersistLayer tse = TaskPersistLayer.getInstance();
        SequenceSpec[] specification = new SequenceSpec[this.m_steps.length];
        for (int i = 0; i < this.m_steps.length; ++i) {
            IJob step = this.m_steps[i];
            BiBusRunSpec runSpec = null;
            if (!(step instanceof IHasTaskRunSpec)) continue;
            IHasTaskRunSpec tseJob = (IHasTaskRunSpec)((Object)step);
            runSpec = tseJob.createTaskRunSpec();
            runSpec.runCommands = new CmdSpec[]{new LogJobCmdSpec()};
            if (inSequence) {
                specification[i] = new SequenceSpec(SequenceSpec.SEQ_NEW, (TaskRunSpec)runSpec);
                if (continueOnError) continue;
                specification[i].setStopOnError(true);
                continue;
            }
            specification[i] = new SequenceSpec(SequenceSpec.SEQ_SAME, (TaskRunSpec)runSpec);
            specification[i].setStopOnError(false);
        }
        try {
            tse.addTasks(TaskID.fromEventId((String)this.m_eventID), specification);
        }
        catch (TaskPersistLayerException e) {
            if (continueOnError) {
                firstJSE = e;
            }
            throw new JobServiceException(I18NCode.JS_EXECUTE_ERROR, e);
        }
        if (firstJSE != null) {
            throw new JobServiceException(I18NCode.JS_EXECUTE_ERROR, firstJSE);
        }
    }

    private synchronized void updateStatus(EventStatus status) {
        this.m_currentStatus = status;
    }

    private boolean getContinueOnError() {
        boolean continueOnError = false;
        Option[] options = this.getAllOptions();
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                JobOptionBoolean joboolean;
                if (!(options[i] instanceof JobOptionBoolean) || !(joboolean = (JobOptionBoolean)options[i]).getName().equals((Object)JobOptionEnum.continueOnError)) continue;
                continueOnError = joboolean.isValue();
                break;
            }
        }
        return continueOnError;
    }

    public boolean isJobDefinition(IJob step) {
        StepDefinition stepDefinition;
        BaseClass stepBaseClass;
        boolean isJobDefinition = false;
        if (step instanceof StepDefinition && (stepBaseClass = (stepDefinition = (StepDefinition)step).getBaseClass()) != null && stepBaseClass instanceof JobDefinition) {
            isJobDefinition = true;
        }
        return isJobDefinition;
    }

    public Option[] getAllOptions() {
        return this.m_allOptions;
    }

    public ParameterValue[] getParams() {
        return this.m_params;
    }

    public void setParams(ParameterValue[] m_params) {
        this.m_params = m_params;
    }

    public JobBiBusHeaders getHeaders() {
        return this.m_headers;
    }

    public void setHeaders(JobBiBusHeaders m_headers) {
        this.m_headers = m_headers;
    }

    private boolean isCancelled() {
        return this.m_cancelled;
    }

    @Override
    public void loadJob() throws JobServiceException {
    }
}

