/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js.impl;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.JobDefinition;
import com.cognos.developer.schemas.bibus._3.JobStepDefinition;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.js.JSCategory;
import com.cognos.js.api.IJob;
import com.cognos.js.api.JobServiceException;
import com.cognos.js.i18n.JobI18NCode;
import com.cognos.js.impl.FaultedJob;
import com.cognos.js.impl.Job;
import com.cognos.js.impl.JobServiceUtil;
import com.cognos.js.impl.JobStep;
import com.cognos.js.impl.StepDefinition;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.RecursionDetector;
import java.util.LinkedList;

public class JobBuilder {
    public static IJob getJob(SearchPathSingleObject path, JobBiBusHeaders headers, ParameterValue[] rtParams, Option[] rtOptions) throws JobServiceException {
        BaseClass[] baseClasses = JobBuilder.getDefinitions(path, headers);
        IJob job = null;
        if (baseClasses.length == 0) {
            job = new FaultedJob(JobI18NCode.MSG_JOB_NO_STEP_OBJECTS, new Object[]{path.get_value()}, headers.getBiBusHeader(), rtOptions, rtParams, path.get_value());
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("No Job definitions found at search path [" + path.get_value() + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.WARN, JobI18NCode.MSG_JOB_MISSING_STEP_OBJECT, new Object[]{path.get_value()});
        } else if (baseClasses.length != 1) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Multiple Job definitions found at search path [" + path + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.JS_MULTIPLE_JOBS);
            job = new FaultedJob(I18NCode.JS_MULTIPLE_JOBS, headers.getBiBusHeader(), rtOptions, rtParams, path.get_value());
        } else {
            for (int j = 0; j < baseClasses.length; ++j) {
                if (baseClasses[j] instanceof JobDefinition) {
                    try {
                        RecursionDetector.testForRecursion((Guid)baseClasses[j].getStoreID().getValue(), (Option[])rtOptions, (JobBiBusHeaders)headers);
                    }
                    catch (SDSServiceException sds) {
                        throw new JobServiceException(sds.getI18NCode(), sds.getParams());
                    }
                    catch (SDKClientException sds) {
                        throw new JobServiceException(sds.getI18NCode(), sds.getParams());
                    }
                    catch (EMFSecurityException sds) {
                        throw new JobServiceException(I18NCode.JS_SUBMIT_ERROR);
                    }
                    if (job != null) continue;
                    job = new Job((JobDefinition)baseClasses[j], headers, rtParams, rtOptions);
                    continue;
                }
                job = new JobStep(baseClasses[j], rtParams, rtOptions, headers);
            }
        }
        return job;
    }

    private static BaseClass[] getDefinitions(SearchPathSingleObject path, JobBiBusHeaders headers) throws JobServiceException {
        QueryRequest[] request = JobBuilder.createJobRequest(path.get_value());
        ContentManagerServiceClientPort cmService = Client.instance().getContentManagerServiceClient(headers);
        QueryReply[] replys = null;
        try {
            replys = cmService.queryMultiple(request);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Error retrieving Job details from CM with searchPath [" + path + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            throw new JobServiceException(I18NCode.PERST_UNABLE_RETRIEVE_JOB_CM, e);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Security Error retrieving Job details from CM with searchPath [" + path + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).debug(e.getLocalizedMessage());
            throw new JobServiceException(I18NCode.PERST_UNABLE_RETRIEVE_JOB_CM);
        }
        finally {
            if (cmService != null) {
                cmService.close();
            }
        }
        BaseClass[] baseClasses = new BaseClass[]{};
        for (int i = 0; i < replys.length; ++i) {
            baseClasses = replys[i].getQueryResult();
        }
        return baseClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IJob[] getStepDefinitions(JobDefinition definition, JobBiBusHeaders headers, ParameterValue[] parentParams, Option[] options, String tenantID) throws EMFSecurityException, SDKClientException, SDSServiceException {
        QueryReply[] replys;
        String path = definition.getSearchPath().getValue();
        QueryRequest[] request = JobBuilder.createStepDefinitionRequest(path);
        ContentManagerServiceClientPort cmService = Client.instance().getContentManagerServiceClient(headers);
        try {
            boolean useTrusted = JobBuilder.shouldUseTrustedRequest(path, cmService);
            if (useTrusted) {
                cmService.signNextRequest("JSM");
            }
            replys = cmService.queryMultiple(request);
        }
        finally {
            if (cmService != null) {
                cmService.close();
            }
        }
        LinkedList<IJob> jobStepList = new LinkedList<IJob>();
        for (int i = 0; i < replys.length; ++i) {
            BaseClass[] baseClasses = replys[i].getQueryResult();
            for (int j = 0; j < baseClasses.length; ++j) {
                if (!(baseClasses[j] instanceof JobStepDefinition)) continue;
                JobStepDefinition jsd = (JobStepDefinition)baseClasses[j];
                IJob jobStep = JobBuilder.buildStepDefinition(jsd, headers, parentParams, options, tenantID);
                jobStepList.add(jobStep);
            }
        }
        return jobStepList.toArray(new IJob[jobStepList.size()]);
    }

    protected static IJob getJobStep(SearchPathSingleObject path, JobBiBusHeaders headers, ParameterValue[] rtParams, Option[] rtOptions) throws JobServiceException {
        BaseClass[] baseClasses = JobBuilder.getDefinitions(path, headers);
        IJob job = null;
        if (baseClasses.length == 0) {
            job = new FaultedJob(JobI18NCode.MSG_JOB_MISSING_STEP_OBJECT, new Object[]{path.get_value()}, headers.getBiBusHeader(), rtOptions, rtParams, path.get_value());
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("No Job Step found at search path [" + path + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.WARN, JobI18NCode.MSG_JOB_MISSING_STEP_OBJECT, new Object[]{path.get_value()});
        } else if (baseClasses.length != 1) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Multiple Job Steps found at search path [" + path + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.JS_MULTIPLE_JOBS);
            job = new FaultedJob(I18NCode.JS_MULTIPLE_JOBS, headers.getBiBusHeader(), rtOptions, rtParams, path.get_value());
        } else {
            for (int j = 0; j < baseClasses.length; ++j) {
                job = new JobStep(baseClasses[j], rtParams, rtOptions, headers);
            }
        }
        return job;
    }

    static QueryRequest[] createJobRequest(String searchPath) {
        QueryRequest jobRequest = new QueryRequest();
        jobRequest.setSearch(searchPath);
        jobRequest.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.sequencing, PropEnum.parameters, PropEnum.options, PropEnum.packageBase, PropEnum.permissions, PropEnum.screenTip, PropEnum.storeID});
        return new QueryRequest[]{jobRequest};
    }

    static QueryRequest[] createStepDefinitionRequest(String searchPath) {
        QueryRequest jobStepDefinitionRequest = new QueryRequest();
        jobStepDefinitionRequest.setSearch(searchPath + "/jobStepDefinition");
        jobStepDefinitionRequest.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.parameters, PropEnum.options, PropEnum.stepObject});
        Sort sort = new Sort();
        sort.setPropName(PropEnum.displaySequence);
        sort.setOrder(OrderEnum.ascending);
        jobStepDefinitionRequest.setSortBy(new Sort[]{sort});
        return new QueryRequest[]{jobStepDefinitionRequest};
    }

    private static IJob buildStepDefinition(JobStepDefinition jsd, JobBiBusHeaders headers, ParameterValue[] params, Option[] options, String tenantID) throws SDKClientException, EMFSecurityException, SDSServiceException {
        BaseClass[] steps;
        BaseClass baseStep = null;
        if (jsd.getStepObject() != null && (steps = jsd.getStepObject().getValue()) != null && steps.length > 0) {
            baseStep = steps[0];
        }
        if (baseStep == null) {
            String path = jsd.getSearchPath().getValue();
            return new FaultedJob(JobI18NCode.MSG_JOB_MISSING_STEP_OBJECT, new Object[]{path}, headers.getBiBusHeader(), options, params, path);
        }
        if (jsd.getOptions() != null) {
            options = OptionUtils.mergeOptions((Option[])options, (Option[])jsd.getOptions().getValue(), (boolean)true, (boolean)true);
        }
        options = OptionUtils.checkLanguageArrayRunOption((Option[])options);
        if (jsd.getParameters() != null) {
            params = JobServiceUtil.mergeParameters(params, jsd.getParameters().getValue());
        }
        return new StepDefinition(baseStep, params, options, headers, tenantID);
    }

    private static boolean shouldUseTrustedRequest(String searchPath, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        boolean shouldUseTrusted = false;
        QueryRequest req = new QueryRequest();
        req.setSearch(searchPath);
        PropEnum[] JOB_PERMISSION_PROPS = new PropEnum[]{PropEnum.permissions};
        req.setProperties(JOB_PERMISSION_PROPS);
        BaseClass baseClass = contentManager.query(req);
        if (baseClass != null) {
            NmtokenArrayProp ppp = baseClass.getPermissions();
            boolean hasRead = AuthenticatorFactory.getInstance().hasPermission(ppp, "read");
            boolean hasTraverse = AuthenticatorFactory.getInstance().hasPermission(ppp, "traverse");
            boolean hasExecute = AuthenticatorFactory.getInstance().hasPermission(ppp, "execute");
            if (!hasRead && hasExecute && hasTraverse) {
                shouldUseTrusted = true;
            }
        }
        return shouldUseTrusted;
    }
}

