/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.js.impl;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.js.JSCategory;
import com.cognos.js.api.IJob;
import com.cognos.js.api.JobServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JobRunManager {
    private static JobRunManager m_instance = new JobRunManager();
    private Map m_active = Collections.synchronizedMap(new HashMap());
    private boolean m_running = true;

    private JobRunManager() {
    }

    public static JobRunManager instance() {
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply run(IJob job) throws JobServiceException {
        AsynchReply reply = null;
        if (!this.isRunning()) {
            return reply;
        }
        try {
            this.m_active.put(job.getID(), job);
            reply = job.run();
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)JSCategory.TRACE).debug("Throwable Error executing Job with EventID [" + job.getID() + "].");
            SDSLogger.getLogger((SDSCategory)JSCategory.RUNTIME).debug(e);
            if (e instanceof JobServiceException) {
                throw (JobServiceException)((Object)e);
            }
            throw new JobServiceException(I18NCode.JS_EXECUTE_ERROR, e);
        }
        finally {
            Map map = this.m_active;
            synchronized (map) {
                this.m_active.remove(job.getID());
                this.m_active.notify();
            }
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String jobId, String userName) {
        try {
            IJob job = (IJob)this.m_active.remove(jobId);
            if (job != null) {
                job.cancel(userName);
            }
        }
        finally {
            this.m_active.remove(jobId);
        }
    }

    public void start() {
        this.setRunning(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.setRunning(false);
        Map map = this.m_active;
        synchronized (map) {
            Iterator iter = this.m_active.values().iterator();
            while (iter.hasNext()) {
                try {
                    IJob job = (IJob)iter.next();
                    job.cancel(null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this.m_active.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        this.setRunning(false);
        Map map = this.m_active;
        synchronized (map) {
            while (!this.m_active.isEmpty()) {
                try {
                    this.m_active.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private synchronized boolean isRunning() {
        return this.m_running;
    }

    private synchronized void setRunning(boolean running) {
        this.m_running = running;
    }
}

