/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsds;

import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class JSDSDiagnosticHandler
extends UtilHandlerBase {
    protected Element xmlConfigData;
    PogoEngine pogoEngine;
    HandlerPool hp;

    public JSDSDiagnosticHandler() {
        super(null);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
        this.xmlConfigData = this.getConfig();
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String action = env.getFormValue("b_action");
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("Diagnostics");
        this.getMemoryDiagnostics(root);
        this.getSAXParserInfo(root);
        this.getXSLTParserInfo(root);
        this.getClassInfo("javax.mail.Transport", root);
        this.getClassInfo("com.sun.mail.smtp.SMTPTransport", root);
        this.getClassInfo("javax.jms.Session", root);
        this.getClassInfo("javax.activation.DataHandler", root);
        this.getClassInfo("org.apache.logging.log4j.Logger", root);
        this.getClassInfo("javax.xml.parsers.SAXParser", root);
        this.getClassInfo("javax.xml.parsers.DocumentBuilder", root);
        this.getClassInfo("org.dom4j.Document", root);
        this.getClassInfo("org.apache.axis.MessageContext", root);
        this.getClassInfo("javax.xml.transform.stream.StreamSource", root);
        this.getClassInfo("javax.xml.rpc.encoding.Deserializer", root);
        this.getClassInfo("javax.xml.namespace.QName", root);
        this.getClassInfo("org.apache.commons.discovery.tools.ClassUtils", root);
        this.getClassInfo("org.apache.commons.httpclient.HttpClient", root);
        this.getClassInfo("javax.xml.soap.SOAPEnvelope", root);
        this.getClassInfo("com.jnetdirect.jsql.JSQLDriver", root);
        this.getClassInfo("oracle.jdbc.driver.OracleDriver", root);
        this.getClassInfo("COM.ibm.db2.jdbc.app.DB2Driver", root);
        ByteArrayOutputStream baosXML = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(baosXML);
            pw.println(root.asXML());
            pw.close();
            JSDSDiagnosticHandler.prepareResponse((MessageContext)mc, (String)"text/xml", (byte[])baosXML.toByteArray());
        }
        catch (IOException x) {
            Fault f = new Fault("IOexception preparing response.", (Exception)x);
            f.setMessageParameters(new Object[]{action});
            mc.setFault(f);
        }
    }

    private void getMemoryDiagnostics(Element root) {
        Runtime rt = Runtime.getRuntime();
        long fm = rt.freeMemory();
        long tm = rt.totalMemory();
        double fmkb = (double)fm / 1000.0;
        double tmkb = (double)tm / 1000.0;
        Element e = this.createSectionTitle(root, "Memory");
        this.createSectionDetails(e, "Amount_of_free_memory_in_the_system", Double.toString(fmkb) + " KB");
        this.createSectionDetails(e, "Total_memory_in_the_JVM", Double.toString(tmkb) + " KB");
    }

    private Element createSectionTitle(Element root, String s) {
        return root.addElement(s);
    }

    private void createSectionDetails(Element e, String key, String value) {
        e.addAttribute(key, value);
    }

    private void getSAXParserInfo(Element root) {
        String s;
        String fs;
        Element element = this.createSectionTitle(root, "SAXParser");
        SAXParserFactory factory = null;
        try {
            factory = SAXParserFactory.newInstance();
            fs = factory.getClass().getName();
        }
        catch (Exception e) {
            fs = "Unknown";
        }
        this.createSectionDetails(element, "factoryClass", fs);
        try {
            SAXParser parserObj = factory.newSAXParser();
            s = parserObj.getClass().getName();
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(element, "parserClass", s);
    }

    private void getXSLTParserInfo(Element root) {
        String s;
        String fs;
        Element element = this.createSectionTitle(root, "XSLTTransformer");
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            fs = factory.getClass().getName();
        }
        catch (Exception e) {
            fs = "Unknown";
        }
        this.createSectionDetails(element, "factoryClass", fs);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            s = factory.newTransformer().getClass().getName();
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(element, "transformerClass", s);
    }

    public void getClassInfo(String fullClass, Element root) {
        Element element = this.createSectionTitle(root, "ClassLoaderCheck");
        String s = "";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            String className = Class.forName(fullClass, true, cl).getName().replace('.', '/');
            s = Class.forName(fullClass).getResource("/" + className + ".class").toString();
        }
        catch (NoClassDefFoundError y) {
            s = "Unknown - NoClassDefFoundError" + y.getMessage();
        }
        catch (Exception e) {
            s = "Unknown Exception - " + e.getMessage();
        }
        catch (Throwable z) {
            s = "Unknown Throwable - " + z.getMessage();
        }
        this.createSectionDetails(element, "class", fullClass);
        this.createSectionDetails(element, "classloader", cl.getClass().getName());
        this.createSectionDetails(element, "load_location", s);
    }
}

