/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.api;

import com.cognos.developer.schemas.bibus._3.AsynchDetailReportValidation;
import com.cognos.jsmcommon.api.ChainedServiceException;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class APIException
extends Exception {
    private static final String EXCEPTION = "exception";
    private static final String SEVERITY = "severity";
    private static final String ERROR_CODE = "errorCode";
    private static final String MESSAGE = "message";
    private static final String MESSAGE_STRING = "messageString";
    private static final String NESTING_LEVEL = "nestingLevel";
    private static final String BUS_NS = "http://developer.cognos.com/schemas/bibus/3/";
    private ArrayList m_exceptions = new ArrayList();
    private Locale m_locale;
    private boolean m_show_nesting;

    public APIException(LocalizableException exception) {
        this(new LocalizableException[]{exception}, Locale.getDefault(), true);
    }

    public APIException(LocalizableException[] exceptions, Locale locale, boolean show_nesting_level) {
        this.m_exceptions.addAll(Arrays.asList(exceptions));
        this.m_locale = locale;
        this.m_show_nesting = show_nesting_level;
    }

    public String getFaultCode(Locale locale) {
        return this.getRootLocalizableException().getI18NCode().getCulprit();
    }

    public String getFaultString(Locale locale) {
        String fault = I18NUtil.getMessage(I18NCode.SOAP_FAULT_CODE_STRING, this.getFaultCode(locale), locale);
        return fault;
    }

    private Element getDetail(Locale locale, Document faultDocument, LocalizableException le_exception) {
        Element exception = faultDocument.createElementNS(BUS_NS, EXCEPTION);
        Element severity = faultDocument.createElementNS(BUS_NS, SEVERITY);
        Element errorCode = faultDocument.createElementNS(BUS_NS, ERROR_CODE);
        severity.appendChild(faultDocument.createTextNode(le_exception.getSeverity().getValue()));
        errorCode.appendChild(faultDocument.createTextNode(this.getSOAPErrorCode(locale)));
        Element[] messages = this.getMessages(faultDocument, le_exception, locale);
        exception.appendChild(severity);
        exception.appendChild(errorCode);
        for (int i = 0; i < messages.length; ++i) {
            exception.appendChild(messages[i]);
        }
        return exception;
    }

    public Element[] getDetails(Locale locale) {
        DocumentBuilderFactory oDBF = DocumentBuilderFactory.newInstance();
        oDBF.setNamespaceAware(true);
        oDBF.setValidating(false);
        oDBF.setIgnoringComments(true);
        oDBF.setIgnoringElementContentWhitespace(true);
        oDBF.setCoalescing(false);
        oDBF.setExpandEntityReferences(true);
        Document doc = null;
        try {
            DocumentBuilder oDB = oDBF.newDocumentBuilder();
            doc = oDB.newDocument();
        }
        catch (ParserConfigurationException pce) {
            return null;
        }
        Element[] exceptions = new Element[this.m_exceptions.size()];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = this.getDetail(locale, doc, (LocalizableException)this.m_exceptions.get(i));
        }
        return exceptions;
    }

    public org.dom4j.Element getDom4JDetail(org.dom4j.Element detail, Locale locale) {
        for (LocalizableException le : this.m_exceptions) {
            this.getDom4JDetailPart(detail, locale, le);
        }
        return detail;
    }

    private org.dom4j.Element getDom4JDetailPart(org.dom4j.Element detail, Locale locale, LocalizableException le) {
        org.dom4j.Element exception = detail.addElement(BIBusEnvelope.BUS_EXCEPTION);
        org.dom4j.Element severity = exception.addElement(SEVERITY);
        severity.addText(le.getSeverity().getValue());
        org.dom4j.Element error_code = exception.addElement(ERROR_CODE);
        error_code.addText(this.getSOAPErrorCode(locale));
        org.dom4j.Element message = exception.addElement(MESSAGE);
        org.dom4j.Element message_string = message.addElement(MESSAGE_STRING);
        message_string.addText(le.getLocalizedMessage(locale));
        org.dom4j.Element level = message.addElement(NESTING_LEVEL);
        level.setText("0");
        return detail;
    }

    public LocalizableException getRootLocalizableException() {
        LocalizableException current;
        Throwable next = current = this.getRootException();
        while (next != null && next instanceof LocalizableException) {
            current = next;
            next = current.getNested();
        }
        return current;
    }

    @Override
    public String getMessage() {
        return this.getRootException().getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage() {
        return this.getRootException().getLocalizedMessage(this.m_locale);
    }

    private Element[] getMessages(Document doc, LocalizableException exception, Locale locale) {
        ArrayList messages = new ArrayList();
        int level = 0;
        this.addMessages(messages, doc, exception, locale, level);
        return messages.toArray(new Element[messages.size()]);
    }

    private void addMessages(List messages, Document doc, LocalizableException exception, Locale locale, int counter) {
        while (exception != null) {
            Throwable nested;
            messages.add(this.getMessage(doc, exception, counter++, locale));
            if (exception instanceof ChainedServiceException) {
                List chain = ((ChainedServiceException)exception).getFaultList();
                for (Object element : chain) {
                    if (element instanceof SDSServiceException) {
                        SDSServiceException next = (SDSServiceException)element;
                        this.addMessages(messages, doc, next, locale, counter);
                        continue;
                    }
                    if (!(element instanceof AsynchDetailReportValidation)) continue;
                    messages.add(this.getMessage(doc, (AsynchDetailReportValidation)element, counter));
                }
            }
            if ((nested = exception.getNested()) != null && nested instanceof LocalizableException) {
                exception = (LocalizableException)nested;
                continue;
            }
            exception = null;
        }
    }

    private LocalizableException getRootException() {
        LocalizableException le = null;
        Iterator iter = this.m_exceptions.iterator();
        while (iter.hasNext() && le == null) {
            Object element = iter.next();
            if (!(element instanceof LocalizableException)) continue;
            le = (LocalizableException)element;
        }
        return le;
    }

    private Element getMessage(Document doc, AsynchDetailReportValidation validation, int level) {
        Element message = doc.createElementNS(BUS_NS, MESSAGE);
        Element message_string = doc.createElementNS(BUS_NS, MESSAGE_STRING);
        Element nesting = doc.createElementNS(BUS_NS, NESTING_LEVEL);
        String val_message = validation.getDefects() != null && validation.getDefects().get_value() != null ? validation.getDefects().get_value() : "";
        message_string.appendChild(doc.createTextNode(val_message));
        nesting.appendChild(doc.createTextNode(String.valueOf(level)));
        message.appendChild(message_string);
        if (this.m_show_nesting) {
            message.appendChild(nesting);
        }
        return message;
    }

    private Element getMessage(Document doc, LocalizableException exception, int level, Locale locale) {
        Element message = doc.createElementNS(BUS_NS, MESSAGE);
        Element message_string = doc.createElementNS(BUS_NS, MESSAGE_STRING);
        Element nesting = doc.createElementNS(BUS_NS, NESTING_LEVEL);
        message_string.appendChild(doc.createTextNode(exception.getLocalizedMessage(locale)));
        nesting.appendChild(doc.createTextNode(String.valueOf(level)));
        message.appendChild(message_string);
        if (this.m_show_nesting) {
            message.appendChild(nesting);
        }
        return message;
    }

    private String getSOAPErrorCode(Locale locale) {
        if (this.getRootLocalizableException().getI18NCode().getCode() == "2107") {
            return this.getRootLocalizableException().getI18NCode().getCode();
        }
        return I18NUtil.getMessage(I18NCode.SOAP_ERROR_CODE_STRING, this.getRootLocalizableException().getI18NCode().getCode(), locale);
    }
}

