/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.audit;

import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.RunOption;
import com.cognos.developer.schemas.bibus._3.RunOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionDateTime;
import com.cognos.developer.schemas.bibus._3.RunOptionInt;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.RunOptionMultilingualString;
import com.cognos.developer.schemas.bibus._3.RunOptionOutputEncapsulation;
import com.cognos.developer.schemas.bibus._3.RunOptionSaveAs;
import com.cognos.developer.schemas.bibus._3.RunOptionString;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class CommonServiceLogUtil {
    private String m_stepId = null;
    private String m_sessionId = null;
    private String m_requestId = null;
    private String m_objectPath = null;
    private String m_subrequestId = null;
    private String m_userName = null;
    private LogTypedLogger m_audit = null;
    private String m_agentPath = null;
    private String m_targetName = null;
    private int m_build_number = -1;
    private static Map m_logger_map = new HashMap();

    public static CommonServiceLogUtil getLogUtil(String categ, Integer buildNumber) {
        CommonServiceLogUtil util = new CommonServiceLogUtil(categ);
        util.setBuildNumber(buildNumber);
        return util;
    }

    public static CommonServiceLogUtil getLogUtil(SDSCategory categ, Integer buildNumber, BiBusHeader biBusHeader, String objectPath) {
        CommonServiceLogUtil util = new CommonServiceLogUtil(categ.toString());
        util.setBuildNumber(buildNumber);
        if (biBusHeader != null) {
            util.setTrackingInfo(biBusHeader);
        }
        util.setObjectPath(objectPath);
        return util;
    }

    public void logASVError(String text) {
        if (this.m_audit.isEnabled(50000)) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication("ASV", this.m_build_number);
            indication.setErrorMessage(text);
            indication.setLevel(30000);
            indication.setObjectPath(this.m_objectPath);
            indication.setObjectType("AgentDefinition");
            indication.setOperation("Run");
            indication.setRequestID(this.m_requestId);
            indication.setSessionID(this.m_sessionId);
            indication.setStatus("Failed");
            indication.setStepID(this.m_stepId);
            indication.setSubRequestID(this.m_subrequestId);
            this.m_audit.log((Object)indication);
        }
    }

    public void logDLSError(String text) {
        if (this.m_audit.isEnabled(50000)) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication("DLS", this.m_build_number);
            indication.setErrorMessage(text);
            indication.setLevel(30000);
            indication.setObjectPath(this.m_objectPath);
            indication.setObjectType("AgentDefinition");
            indication.setOperation("Run");
            indication.setRequestID(this.m_requestId);
            indication.setSessionID(this.m_sessionId);
            indication.setStatus("Failed");
            indication.setStepID(this.m_stepId);
            indication.setSubRequestID(this.m_subrequestId);
            this.m_audit.log((Object)indication);
        }
    }

    public void logDLSReportOutputArchive(String text) {
        if (this.m_audit.isEnabled(50000)) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication("DLS", this.m_build_number);
            indication.setLogData(text);
            indication.setLevel(30000);
            indication.setObjectPath(this.m_objectPath);
            indication.setObjectType("Report");
            indication.setOperation("Deliver");
            indication.setRequestID(this.m_requestId);
            indication.setSessionID(this.m_sessionId);
            indication.setStatus("Success");
            indication.setStepID(this.m_stepId);
            indication.setSubRequestID(this.m_subrequestId);
            this.m_audit.log((Object)indication);
        }
    }

    public void logASVDebug(String text) {
        if (this.m_audit.isEnabled(10000)) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication("ASV", this.m_build_number);
            indication.setErrorMessage(text);
            indication.setLevel(10000);
            indication.setObjectPath(this.m_objectPath);
            indication.setObjectType("AgentDefinition");
            indication.setOperation("Run");
            indication.setRequestID(this.m_requestId);
            indication.setSessionID(this.m_sessionId);
            indication.setStatus("Success");
            indication.setStepID(this.m_stepId);
            indication.setSubRequestID(this.m_subrequestId);
            this.m_audit.log((Object)indication);
        }
    }

    public void logDLSDebug(String text) {
        if (this.m_audit.isEnabled(10000)) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication("DLS", this.m_build_number);
            indication.setErrorMessage(text);
            indication.setLevel(10000);
            indication.setObjectPath(this.m_objectPath);
            indication.setObjectType("AgentDefinition");
            indication.setOperation("Run");
            indication.setRequestID(this.m_requestId);
            indication.setSessionID(this.m_sessionId);
            indication.setStatus("Success");
            indication.setStepID(this.m_stepId);
            indication.setSubRequestID(this.m_subrequestId);
            this.m_audit.log((Object)indication);
        }
    }

    public void logMessageSubmit(ParameterValue[] parameters, Option[] options, String messageId) {
        try {
            if (this.m_audit.isEnabled(30000)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)out, "UTF-8");
                OutputFormat outFormat = new OutputFormat();
                XMLWriter writer = new XMLWriter((Writer)outStream, outFormat);
                outFormat.setSuppressDeclaration(true);
                this.writeParameters(outStream, parameters, options, messageId);
                LogAuditAccessIndication indication = new LogAuditAccessIndication("DLS", this.m_build_number);
                if (null != this.m_requestId && null != this.m_sessionId) {
                    indication.setErrorMessage("N/A");
                    indication.setLevel(30000);
                    indication.setLogData(new String(out.toByteArray(), "UTF-8"));
                    indication.setObjectPath(this.m_objectPath);
                    indication.setObjectType("AgentDefinition");
                    indication.setOperation("Run");
                    indication.setRequestID(this.m_requestId);
                    indication.setSessionID(this.m_sessionId);
                    indication.setStepID(this.m_stepId);
                    indication.setSubRequestID(this.m_subrequestId);
                    indication.setStatus("Success");
                    this.m_audit.log((Object)indication);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logAgentRun(ParameterValue[] parameters, Option[] options, String messageId, String status, String errorMessage) {
        try {
            if (this.m_audit.isEnabled(30000)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)out, "UTF-8");
                OutputFormat outFormat = new OutputFormat();
                XMLWriter writer = new XMLWriter((Writer)outStream, outFormat);
                outFormat.setSuppressDeclaration(true);
                this.writeParameters(outStream, parameters, options, messageId);
                LogAuditAccessIndication indication = new LogAuditAccessIndication("ASV", this.m_build_number);
                indication.setErrorMessage(errorMessage != null && !errorMessage.trim().equals("") ? errorMessage : "N/A");
                indication.setLevel(30000);
                indication.setLogData(new String(out.toByteArray(), "UTF-8"));
                indication.setObjectPath(this.m_objectPath + "/" + this.m_targetName);
                indication.setObjectType("AgentDefinition");
                indication.setOperation("Run");
                indication.setRequestID(this.m_requestId);
                indication.setSessionID(this.m_sessionId);
                indication.setStepID(this.m_stepId);
                indication.setStatus(status);
                indication.setSubRequestID(this.m_subrequestId);
                this.m_audit.log((Object)indication);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logServiceStart() {
        if (this.m_audit.isEnabled(50000)) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication("JS", this.m_build_number);
            indication.setLevel(50000);
            indication.setObjectPath(this.m_objectPath);
            indication.setObjectType("AgentService");
            indication.setOperation("StartService");
            indication.setRequestID(this.m_requestId);
            indication.setSessionID(this.m_sessionId);
            indication.setStatus("Success");
            indication.setStepID(this.m_stepId);
            indication.setSubRequestID(this.m_subrequestId);
            this.m_audit.log((Object)indication);
        }
    }

    public void logServiceStop() {
        if (this.m_audit.isEnabled(50000)) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication("JS", this.m_build_number);
            indication.setLevel(50000);
            indication.setObjectPath(this.m_objectPath);
            indication.setObjectType("AgentService");
            indication.setOperation("StopService");
            indication.setRequestID(this.m_requestId);
            indication.setSessionID(this.m_sessionId);
            indication.setStatus("Success");
            indication.setStepID(this.m_stepId);
            indication.setSubRequestID(this.m_subrequestId);
            this.m_audit.log((Object)indication);
        }
    }

    public void setObjectPath(String objectPath) {
        this.m_objectPath = objectPath;
    }

    public void setTrackingInfo(BiBusHeader header) {
        Tracking tracking = header.getTracking();
        if (tracking != null) {
            String stepContext;
            String sessionContext;
            String requestContext;
            BigInteger hopCount = tracking.getHopCount();
            if (hopCount != null) {
                this.m_subrequestId = hopCount.toString();
            }
            this.m_requestId = requestContext = tracking.getRequestContext();
            this.m_sessionId = sessionContext = tracking.getSessionContext();
            this.m_stepId = stepContext = tracking.getStepContext();
        }
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public boolean isDebugOn() {
        return this.m_audit.isEnabled(10000);
    }

    private String getOptionName(Option option) {
        String name = "";
        if (option instanceof RunOption) {
            name = ((RunOption)option).getName().getValue();
        } else if (option instanceof DeliveryOption) {
            name = ((DeliveryOption)option).getName().getValue();
        }
        return name;
    }

    private void setBuildNumber(Integer i) {
        this.m_build_number = i;
    }

    private void writeParameters(OutputStreamWriter outStream, ParameterValue[] parameters, Option[] options, String messageId) {
        try {
            int idx;
            outStream.write(new String("<parameters>"));
            this.writeUserName(outStream, this.m_userName);
            this.writeAddress(outStream, options);
            this.writeAgentPath(outStream, this.m_agentPath);
            this.writeMessageId(outStream, messageId);
            if (parameters != null && parameters.length > 0) {
                for (idx = 0; idx < parameters.length; ++idx) {
                    outStream.write(new String("<item name='" + parameters[idx].getName() + "'><![CDATA["));
                    ParmValueItem[] params = parameters[idx].getValue();
                    for (int jdx = 0; jdx < params.length; ++jdx) {
                        outStream.write(ObjectModelUtil.getParameterValue(params[jdx]));
                    }
                    outStream.write("]]></item>");
                }
            }
            if (options != null && options.length > 0) {
                for (idx = 0; idx < options.length; ++idx) {
                    int i;
                    MemoPart value;
                    String optionName = this.getOptionName(options[idx]);
                    if (optionName == null || optionName.trim().length() <= 0) continue;
                    outStream.write(new String("<item name='" + optionName + "'><![CDATA["));
                    if (options[idx] instanceof RunOptionAnyURI) {
                        value = ((RunOptionAnyURI)options[idx]).getValue();
                        outStream.write((String)value);
                    }
                    if (options[idx] instanceof RunOptionBoolean) {
                        value = "" + ((RunOptionBoolean)options[idx]).isValue();
                        outStream.write((String)value);
                    }
                    if (options[idx] instanceof RunOptionDateTime) {
                        value = ((RunOptionDateTime)options[idx]).getValue().getTime().toString();
                        outStream.write((String)value);
                    }
                    if (options[idx] instanceof RunOptionInt) {
                        value = "" + ((RunOptionInt)options[idx]).getValue();
                        outStream.write((String)value);
                    }
                    if (options[idx] instanceof RunOptionLanguageArray) {
                        value = ((RunOptionLanguageArray)options[idx]).getValue();
                        for (i = 0; i < ((String[])value).length; ++i) {
                            outStream.write(value[i]);
                            if (i >= ((String[])value).length - 1) continue;
                            outStream.write(",");
                        }
                    }
                    if (options[idx] instanceof RunOptionMultilingualString) {
                        value = ((RunOptionMultilingualString)options[idx]).getValue();
                        for (i = 0; i < ((String[])value).length; ++i) {
                            outStream.write(new String("\"" + value[i].getLocale() + "," + value[i].getValue() + "\""));
                            if (i >= ((String[])value).length - 1) continue;
                            outStream.write(",");
                        }
                    }
                    if (options[idx] instanceof RunOptionOutputEncapsulation) {
                        value = ((RunOptionOutputEncapsulation)options[idx]).getValue().getValue();
                        outStream.write((String)value);
                    }
                    if (options[idx] instanceof RunOptionSaveAs) {
                        // empty if block
                    }
                    if (options[idx] instanceof RunOptionString) {
                        value = ((RunOptionString)options[idx]).getValue();
                        outStream.write((String)value);
                    }
                    if (options[idx] instanceof RunOptionStringArray) {
                        value = ((RunOptionStringArray)options[idx]).getValue();
                        for (i = 0; i < ((String[])value).length; ++i) {
                            outStream.write(value[i]);
                            if (i >= ((String[])value).length - 1) continue;
                            outStream.write(",");
                        }
                    }
                    if (options[idx] instanceof DeliveryOptionString) {
                        value = ((DeliveryOptionString)options[idx]).getValue();
                        outStream.write((String)value);
                    }
                    if (options[idx] instanceof DeliveryOptionAddressSMTPArray) {
                        value = ((DeliveryOptionAddressSMTPArray)options[idx]).getValue();
                        for (i = 0; i < ((String[])value).length; ++i) {
                            outStream.write(value[i].get_value());
                            if (i >= ((MemoPart)value).length - 1) continue;
                            outStream.write(",");
                        }
                    }
                    if (options[idx] instanceof DeliveryOptionMemoPart) {
                        value = ((DeliveryOptionMemoPart)options[idx]).getValue();
                        SmtpContentDispositionEnum name = value.getContentDisposition();
                        if (name != null) {
                            outStream.write("memoPart");
                        } else {
                            outStream.write("null");
                        }
                    }
                    outStream.write("]]></item>");
                }
            }
            outStream.write(new String("</parameters>"));
            outStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeModelName(OutputStreamWriter outStream, String modelName) {
        try {
            outStream.write(new String("<item name='MODEL'><![CDATA["));
            if (modelName != null) {
                if (modelName.length() != 0) {
                    outStream.write(modelName);
                } else {
                    outStream.write(new String("N/A"));
                }
            } else {
                outStream.write(new String("N/A"));
            }
            outStream.write(new String("]]></item>"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeUserName(OutputStreamWriter outStream, String userName) {
        try {
            outStream.write(new String("<item name='USER'><![CDATA["));
            if (userName != null) {
                if (userName.length() != 0) {
                    outStream.write(userName);
                } else {
                    outStream.write(new String("N/A"));
                }
            } else {
                outStream.write(new String("N/A"));
            }
            outStream.write(new String("]]></item>"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeAddress(OutputStreamWriter outStream, Option[] options) {
        try {
            if (options != null && options.length > 0) {
                for (int idx = 0; idx < options.length; ++idx) {
                    DeliveryOptionEnum name;
                    if (!(options[idx] instanceof DeliveryOptionAddressSMTPArray) || (name = ((DeliveryOptionAddressSMTPArray)options[idx]).getName()).getValue() != "toAddress") continue;
                    AddressSMTP[] value = ((DeliveryOptionAddressSMTPArray)options[idx]).getValue();
                    outStream.write(new String("<item name='EMAIL'><![CDATA["));
                    for (int i = 0; i < value.length; ++i) {
                        String address = value[i].toString();
                        if (address != null && address.length() != 0) {
                            outStream.write(address);
                            if (i >= value.length - 1) continue;
                            outStream.write(",");
                            continue;
                        }
                        outStream.write(new String("N/A"));
                    }
                    outStream.write(new String("]]></item>"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeAgentPath(OutputStreamWriter outStream, String agentPath) {
        try {
            outStream.write(new String("<item name='AGENTPATH'><![CDATA["));
            if (agentPath != null && agentPath.length() != 0) {
                outStream.write(agentPath);
            } else {
                outStream.write(new String("N/A"));
            }
            outStream.write(new String("]]></item>"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeMessageId(OutputStreamWriter outStream, String messageId) {
        try {
            outStream.write(new String("<item name='MESSAGEID'><![CDATA["));
            if (messageId != null) {
                if (messageId.length() != 0) {
                    outStream.write(messageId);
                } else {
                    outStream.write(new String("N/A"));
                }
            } else {
                outStream.write(new String("N/A"));
            }
            outStream.write(new String("]]></item>"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeScheduleTime(OutputStreamWriter outStream, String sheduleTime) {
        try {
            outStream.write(new String("<item name='SCHEDULETIME'><![CDATA["));
            if (sheduleTime != null) {
                if (sheduleTime.length() != 0) {
                    outStream.write(sheduleTime);
                } else {
                    outStream.write(new String("N/A"));
                }
            } else {
                outStream.write(new String("N/A"));
            }
            outStream.write(new String("]]></item>"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LogTypedLogger getLogger(String category) {
        LogTypedLogger logger = null;
        logger = m_logger_map.containsKey(category) ? (LogTypedLogger)m_logger_map.get(category) : LogTypedLogger.getInstance((String)category, LogAuditAccessIndication.class);
        return logger;
    }

    private CommonServiceLogUtil(String category) {
        this.m_audit = this.getLogger(category);
    }

    public void setTargetName(String targetName) {
        this.m_targetName = targetName;
    }

    public void setAgentPath(String agentPath) {
        this.m_agentPath = agentPath;
    }
}

