/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.event;

import com.cognos.jsmcommon.i18n.I18NCode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EventStatus
implements Serializable {
    private String m_event_status_name;
    private I18NCode m_event_status_code;
    private static Map m_all_of_em = new HashMap();
    private boolean m_terminating;
    public static final EventStatus INACTIVE = new EventStatus("inactive", I18NCode.EVENT_PARAM_INA);
    public static final EventStatus EXECUTING = new EventStatus("executing", I18NCode.EVENT_PARAM_EXE);
    public static final EventStatus FAILED = new EventStatus("failed", I18NCode.EVENT_PARAM_FAI, true);
    public static final EventStatus PENDING = new EventStatus("pending", I18NCode.EVENT_PARAM_PEN);
    public static final EventStatus PURGED = new EventStatus("purged", I18NCode.EVENT_PARAM_PUR, true);
    public static final EventStatus SCHEDULED = new EventStatus("scheduled", I18NCode.EVENT_PARAM_SCH);
    public static final EventStatus SUCCEEDED = new EventStatus("succeeded", I18NCode.EVENT_PARAM_SUC, true);
    public static final EventStatus CANCELLED = new EventStatus("cancelled", I18NCode.EVENT_PARAM_CAN, true);
    public static final EventStatus SUSPENDED = new EventStatus("suspended", I18NCode.EVENT_PARAM_SUS);
    public static final EventStatus TERMINATED = new EventStatus("terminated", I18NCode.EVENT_PARAM_TER, true);
    public static final EventStatus SDS_NEW = new EventStatus("sds_new", I18NCode.EVENT_PARAM_SDS);

    private EventStatus(String status_name, I18NCode msgCode, boolean terminating) {
        this.m_event_status_name = status_name;
        this.m_event_status_code = msgCode;
        m_all_of_em.put(status_name, this);
        this.m_terminating = terminating;
    }

    private EventStatus(String status_name, I18NCode msgCode) {
        this(status_name, msgCode, false);
    }

    public boolean isTerminating() {
        return this.m_terminating;
    }

    public String statusName() {
        return this.m_event_status_name;
    }

    public I18NCode statusMsgCode() {
        return this.m_event_status_code;
    }

    public String toString() {
        return this.m_event_status_name;
    }

    public static EventStatus valueOf(String event_status) {
        return (EventStatus)m_all_of_em.get(event_status);
    }

    public boolean isEqualTo(EventStatus rhs) {
        return rhs != null ? rhs.statusName().equals(this.statusName()) : false;
    }

    public boolean equals(Object rhs) {
        boolean equals = rhs instanceof EventStatus;
        return equals && this.isEqualTo((EventStatus)rhs);
    }

    public int hashCode() {
        return this.m_event_status_name.hashCode();
    }
}

