/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.event;

import com.cognos.jsmcommon.event.EventStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class EventStatusInfo {
    public static final String ALL = "all";
    public static final String NONE = "none";
    private Set m_infoSet = null;
    private EventStatus m_eventStatus;
    private String[] m_info;
    private Properties props = new Properties();

    public EventStatusInfo(EventStatus eventStatus) {
        this.m_eventStatus = eventStatus;
    }

    public EventStatusInfo(String data) {
        this(data, ";");
    }

    public EventStatusInfo(String data, String separator) {
        ArrayList<String> infoList = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(data, separator);
        int i = 0;
        while (tokens.hasMoreTokens()) {
            if (i == 0) {
                this.m_eventStatus = EventStatus.valueOf(tokens.nextToken());
            } else {
                String token = tokens.nextToken();
                this.parseInfoToken(token, infoList);
            }
            ++i;
        }
        this.m_info = infoList.toArray(new String[0]);
    }

    private void parseInfoToken(String info, ArrayList<String> infoList) {
        if (info == null || "".equals(info)) {
            return;
        }
        String[] values = info.split("=");
        if (values.length <= 1) {
            infoList.add(info);
        } else if (values.length == 2) {
            this.props.setProperty(values[0], values[1]);
        }
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.props;
    }

    public EventStatus getEventStatus() {
        return this.m_eventStatus;
    }

    public String[] getInfo() {
        return this.m_info;
    }

    public void setInfo(String[] info) {
        this.m_info = info;
    }

    public Set getInfoAsSet() {
        if (this.m_infoSet == null) {
            this.m_infoSet = new HashSet();
            for (int i = 0; i < this.m_info.length; ++i) {
                this.m_infoSet.add(this.m_info[i]);
            }
        }
        return this.m_infoSet;
    }

    public boolean isToBeRun(String eventId) {
        boolean runIt = this.getInfoAsSet().contains(ALL);
        if (!runIt && !this.getInfoAsSet().contains(NONE)) {
            runIt = this.getInfoAsSet().contains(eventId);
        }
        return runIt;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_eventStatus.statusName());
        for (int i = 0; i < this.m_info.length; ++i) {
            buffer.append(";");
            buffer.append(this.m_info[i]);
        }
        for (Object prop : this.props.keySet()) {
            buffer.append(";");
            String val = (String)this.props.get(prop);
            buffer.append(prop + "=" + val);
        }
        return buffer.toString();
    }
}

