/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.event;

import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.jsmcommon.event.EventStatus;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventStatusUtil {
    private static final Map m_states = new HashMap(15);

    private EventStatusUtil() {
    }

    public static boolean validateHistoryContainment(History parent, History child) {
        return parent == null || child == null || EventStatusUtil.validateHistoryContainment(EventStatus.valueOf(parent.getStatus().getValue()), EventStatus.valueOf(child.getStatus().getValue()));
    }

    public static boolean validateHistoryContainment(EventStatus parent, EventStatus child) {
        return m_states.containsKey(parent) && ((List)m_states.get(parent)).contains(child);
    }

    public static EventStatus getEventStatus(AsynchReplyStatusEnum statusEnum) {
        EventStatus eventStatus = EventStatus.FAILED;
        if (statusEnum.equals((Object)AsynchReplyStatusEnum.complete)) {
            eventStatus = EventStatus.SUCCEEDED;
        } else if (statusEnum.equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
            eventStatus = EventStatus.SUCCEEDED;
        } else if (statusEnum.equals((Object)AsynchReplyStatusEnum.working)) {
            eventStatus = EventStatus.EXECUTING;
        } else if (statusEnum.equals((Object)AsynchReplyStatusEnum.stillWorking)) {
            eventStatus = EventStatus.EXECUTING;
        }
        return eventStatus;
    }

    static {
        m_states.put(EventStatus.CANCELLED, Arrays.asList(EventStatus.CANCELLED));
        m_states.put(EventStatus.PURGED, Arrays.asList(new EventStatus[0]));
        m_states.put(EventStatus.TERMINATED, Arrays.asList(new EventStatus[0]));
        m_states.put(EventStatus.SUCCEEDED, Arrays.asList(EventStatus.SUCCEEDED));
        m_states.put(EventStatus.FAILED, Arrays.asList(EventStatus.FAILED, EventStatus.SUCCEEDED));
    }
}

