/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.http;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.property.CRNProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class HTTPRequest {
    private String m_body;
    private String m_soapAction;
    private String dispatcherUrl;

    public HTTPRequest(String soapAction) {
        this.m_soapAction = soapAction;
    }

    public HTTPRequest(String soapAction, String dispatcherUrl) {
        this.m_soapAction = soapAction;
        this.dispatcherUrl = dispatcherUrl;
    }

    public URL getURL() throws LocalizableException {
        URL url = null;
        Object urlString = null;
        try {
            if (this.dispatcherUrl == null || "".equals(this.dispatcherUrl)) {
                this.dispatcherUrl = CRNProperties.getInstance().getProperty("internalDispatcher");
            }
            url = new URL(this.dispatcherUrl);
        }
        catch (Exception e) {
            throw new SDSServiceException(I18NCode.MSG_HTTP_REQUEST_FAILED, new Object[]{urlString}, e);
        }
        return url;
    }

    public String retrieveContent() throws LocalizableException {
        PostMethod method = null;
        try {
            StringBuffer response = new StringBuffer();
            URL url = this.getURL();
            HttpClient client = this.createClientConnection(url);
            method = this.executeRequest(url);
            client.executeMethod((HttpMethod)method);
            if (method.getResponseHeader("Content-Type").getValue().equalsIgnoreCase("text/html")) {
                // empty if block
            }
            if (method.getResponseHeader("Content-Length") != null) {
                long l = Long.parseLong(method.getResponseHeader("Content-Length").getValue());
            }
            if (method == null) {
                String string = null;
                return string;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
            String buffer = reader.readLine();
            while (buffer != null) {
                response.append(buffer);
                buffer = reader.readLine();
            }
            String string = response.toString();
            return string;
        }
        catch (IOException e) {
            throw new SDSServiceException(I18NCode.MSG_HTTP_REQUEST_FAILED, (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    protected PostMethod executeRequest(URL url) {
        PostMethod method = new PostMethod(url.toString());
        method.setRequestHeader("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
        method.setRequestHeader("Accept-Encoding", "gzip, deflate");
        method.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)");
        method.setRequestHeader("SOAPAction", this.m_soapAction);
        method.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        try {
            method.setRequestHeader("Content-Length", "" + this.getRequestBody().getBytes("utf-8").length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        method.setRequestBody(this.getRequestBody());
        return method;
    }

    protected String getRequestBody() {
        return this.m_body;
    }

    public void setRequestBody(String body) {
        this.m_body = body;
    }

    protected HttpClient createClientConnection(URL url) throws LocalizableException {
        HttpClient client;
        if (url.getProtocol().equalsIgnoreCase("https")) {
            CAMFactory cf = new CAMFactory();
            byte[] initDoc = "<initializeDocument><serviceID>SDS</serviceID></initializeDocument>".getBytes();
            try {
                cf.initialize(initDoc);
                client = cf.createHttpClient(url);
            }
            catch (Exception e) {
                throw new SDSServiceException(I18NCode.MSG_HTTP_REQUEST_FAILED, (Throwable)e);
            }
        } else {
            client = new HttpClient();
        }
        return client;
    }
}

