/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.i18n;

import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import java.util.Arrays;
import java.util.Locale;

public class I18NMessage {
    private I18NCode m_code;
    private Object[] m_prams;
    private SeverityEnum m_severity = SeverityEnum.error;
    private String m_message;

    public I18NMessage(LocalizableException le) {
        this(le.getI18NCode(), le.getParams(), le.getSeverity());
    }

    public I18NMessage(I18NCode code, Object[] prams, SeverityEnum severity) {
        this.m_code = code;
        this.m_prams = prams;
        if (severity != null) {
            this.m_severity = severity;
        }
    }

    public I18NCode getCode() {
        return this.m_code;
    }

    public void setCode(I18NCode code) {
        this.m_code = code;
    }

    public Object[] getParams() {
        return this.m_prams;
    }

    public void setParams(Object[] params) {
        this.m_prams = params;
    }

    public String getMessage(Locale locale) {
        return this.m_message != null ? this.m_message : I18NUtil.getMessage(this.m_code, this.m_prams, locale);
    }

    public SeverityEnum getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.m_severity = severity;
    }

    public boolean equals(Object obj) {
        I18NMessage toMsg = (I18NMessage)obj;
        boolean equal = toMsg.getCode().equals(this.getCode());
        equal = equal && Arrays.equals(toMsg.getParams(), this.getParams());
        return equal;
    }
}

