/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.i18n;

import com.cognos.jsmcommon.i18n.EscapingMessageFormat;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.XMLResource;
import com.cognos.jsmcommon.i18n.XMLResourceGenerator;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NUtil {
    public static String getMessage(I18NCode messageCode, Locale locale) {
        return I18NUtil.getMessage(messageCode, new Object[0], locale);
    }

    public static String getMessage(I18NCode messageCode, Object param, Locale locale) {
        return I18NUtil.getMessage(messageCode, new Object[]{param}, locale);
    }

    public static String getMessage(I18NCode messageCode, Object[] params, Locale locale) {
        String localised = null;
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (I18NCode.GEN_3RD_PARTY_FAULT.getCode().equals(messageCode.getCode())) {
            return params != null && params.length >= 1 ? (String)params[0] : "";
        }
        String messageBase = messageCode.getMessageBase() != null ? messageCode.getMessageBase() : "ncmsg";
        ResourceBundle sys_bundle = I18NUtil.getResourceBundle(messageBase, locale);
        String stub = I18NUtil.getLocalizedText(sys_bundle, locale, messageCode.getCode());
        if (null == params || params.length == 0) {
            localised = stub;
        } else {
            Object[] theParams = I18NUtil.getLocalizedParams(sys_bundle, locale, params);
            localised = EscapingMessageFormat.format(stub, theParams);
        }
        return localised;
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(baseName, locale);
        }
        catch (MissingResourceException exc) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(exc);
            bundle = ResourceBundle.getBundle(baseName, Locale.ENGLISH);
        }
        return bundle;
    }

    private static ResourceBundle getDefResourceBundle() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("ncmsg", Locale.ENGLISH);
        }
        catch (MissingResourceException exc) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(exc);
        }
        return bundle;
    }

    private static Object[] getLocalizedParams(ResourceBundle resource, Locale locale, Object[] params) {
        if (params == null || params.length < 1) {
            return params;
        }
        Object[] result = new Object[params.length];
        String oneMsg = null;
        I18NCode oneCode = null;
        for (int counter = 0; counter < params.length; ++counter) {
            if (params[counter] != null && params[counter] instanceof I18NCode) {
                oneCode = (I18NCode)params[counter];
                oneMsg = I18NUtil.getLocalizedText(resource, locale, oneCode.getCode());
                result[counter] = oneMsg;
                continue;
            }
            result[counter] = params[counter];
        }
        return result;
    }

    private static String getLocalizedText(ResourceBundle resource, Locale locale, String messageCode) {
        String result = "";
        try {
            result = resource.getString(messageCode);
        }
        catch (MissingResourceException e) {
            try {
                result = I18NUtil.getDefResourceBundle().getString(messageCode);
            }
            catch (MissingResourceException mx) {
                result = I18NUtil.getLocalizedTextFromXML(locale, messageCode);
            }
        }
        return result;
    }

    private static String getLocalizedTextFromXML(Locale locale, String messageCode) {
        String result = "";
        XMLResource rt_resource = XMLResourceGenerator.getResource(locale);
        try {
            result = rt_resource == null ? "[" + messageCode + "]" : rt_resource.getString(messageCode);
        }
        catch (MissingResourceException e1) {
            result = I18NUtil.getLocalizedTextFromLegacy(locale, messageCode);
        }
        return result;
    }

    private static String getLocalizedTextFromLegacy(Locale locale, String messageCode) {
        String result = "";
        ResourceBundle legacy_bundle = null;
        try {
            legacy_bundle = ResourceBundle.getBundle("LegacyResource", locale);
            result = legacy_bundle.getString(messageCode);
        }
        catch (MissingResourceException e2) {
            result = "Error message missing in resources for error code [" + messageCode + "] in locale [" + locale.getDisplayName() + "].";
        }
        return result;
    }
}

