/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.i18n;

import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class LocaleFileManager {
    private Integer m_languagesSupported;
    private static final String XML_EXTENSION = ".xml";
    private String m_locale_dir;
    private String current_locale_dir = null;
    private String last_locale_dir = "?";
    protected static final String FILENAME = "ncmsgrt";
    private String cognosBinDir = null;
    private static final Locale m_default_locale = new Locale("en", "US");
    private Map m_language_files;
    private static final String UNDERSCORE_CN = "zh_CN";
    private static final String DASH_CN = "zh-cn";

    protected LocaleFileManager() {
        String localeDir = ".." + File.separator + "sds" + File.separator + "conf" + File.separator + "locale";
        CRNProperties crnProperties = CRNProperties.getInstance();
        this.cognosBinDir = crnProperties.getProperties().getProperty("pwd");
        this.m_locale_dir = crnProperties.getProperties().getProperty("localisation_dir", localeDir);
        if (null != this.cognosBinDir) {
            StringBuffer buffer = new StringBuffer(this.cognosBinDir.length() + this.m_locale_dir.length() + 1);
            buffer.append(this.cognosBinDir);
            buffer.append(File.separatorChar);
            buffer.append(this.m_locale_dir);
            this.m_locale_dir = buffer.toString();
        }
        this.m_language_files = new HashMap();
    }

    public File getLanguageFile(String fileName) {
        File file = null;
        if (this.m_language_files.containsKey(fileName)) {
            file = (File)this.m_language_files.get(fileName);
        } else {
            file = this.getFile(fileName);
            if (file == null) {
                file = this.getSimplifiedChineseFile(fileName);
            }
            if (file == null) {
                file = this.getFile(fileName.toLowerCase());
            }
            if (file != null) {
                this.m_language_files.put(fileName, file);
            } else {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Unable to find or read language file: " + fileName);
            }
        }
        return file;
    }

    protected File getRootLanguageFile() {
        File rootFile = this.getLanguageFile(FILENAME);
        if (rootFile == null) {
            throw new MissingResourceException("Unable to find or read language file ncmsgrt", this.getClass().getName(), FILENAME);
        }
        return rootFile;
    }

    private File getFile(String fileName) {
        String current_locale_dir = this.m_locale_dir;
        File dir = new File(current_locale_dir);
        String name = fileName + XML_EXTENSION;
        File file = new File(dir, name);
        if (!this.checkFile(file)) {
            file = null;
        }
        return file;
    }

    private File getSimplifiedChineseFile(String fileName) {
        File file = null;
        int isSimpleChinese = fileName.indexOf(UNDERSCORE_CN);
        if (isSimpleChinese > 0 && !this.checkFile(file = this.getFile(fileName = fileName.substring(0, isSimpleChinese) + DASH_CN + fileName.substring(isSimpleChinese + UNDERSCORE_CN.length(), fileName.length())))) {
            file = null;
        }
        return file;
    }

    private boolean checkFile(File file) {
        return file != null && file.exists() && file.canRead();
    }

    public int getLanguagesSupported() {
        if (this.m_languagesSupported == null) {
            File lang = new File(this.m_locale_dir + File.separatorChar);
            File[] filesOrDirs = lang.listFiles();
            int count = 0;
            if (filesOrDirs != null) {
                for (int x = 0; x < filesOrDirs.length; ++x) {
                    if (filesOrDirs[x].isDirectory()) {
                        File[] langFiles = filesOrDirs[x].listFiles();
                        for (int y = 0; y < langFiles.length; ++y) {
                            if (langFiles[y].getName().indexOf(FILENAME) == -1) continue;
                            ++count;
                        }
                        continue;
                    }
                    if (filesOrDirs[x].getName().indexOf(FILENAME) == -1) continue;
                    ++count;
                }
            }
            this.m_languagesSupported = new Integer(count);
        }
        return this.m_languagesSupported;
    }

    public class LocalFileFilter
    implements FilenameFilter {
        String m_localeName;

        private LocalFileFilter(String name) {
            this.m_localeName = name;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean result = false;
            if (this.m_localeName.equalsIgnoreCase(name)) {
                result = true;
            }
            return result;
        }
    }
}

