/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.i18n;

import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import java.util.Locale;

public abstract class LocalizableException
extends Exception {
    private SeverityEnum m_severity = SeverityEnum.error;
    private I18NCode m_code;
    private Object[] m_params;
    private Throwable m_nested;
    private String m_eventId;

    public SeverityEnum getSeverity() {
        return this.m_severity;
    }

    protected void setSeverity(SeverityEnum severity) {
        this.m_severity = severity;
    }

    protected void setParams(Object[] params) {
        this.m_params = params;
    }

    public LocalizableException(I18NCode code) {
        this(code, new Object[0], null);
    }

    public LocalizableException(I18NCode code, Object[] params) {
        this(code, params, null);
    }

    public LocalizableException(I18NCode code, Throwable nested) {
        this(code, new Object[0], nested, null);
    }

    public LocalizableException(I18NCode code, Object[] params, Throwable nested) {
        this(code, params, nested, null);
    }

    public LocalizableException(I18NCode code, Object[] params, Throwable nested, SeverityEnum severity) {
        if (severity != null) {
            this.m_severity = severity;
        }
        this.m_code = code;
        this.m_nested = nested;
        this.m_params = params;
    }

    public String getLocalizedMessage(Locale locale) {
        return I18NUtil.getMessage(this.getI18NCode(), this.getParams(), locale);
    }

    public Throwable getNested() {
        return this.m_nested;
    }

    @Override
    public Throwable getCause() {
        return this.m_nested;
    }

    public I18NCode getI18NCode() {
        return this.m_code;
    }

    public Object[] getParams() {
        return this.m_params;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String toString() {
        return this.getLocalizedMessage();
    }
}

