/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.i18n;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocaleFileManager;
import com.cognos.jsmcommon.i18n.XMLResource;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultEntity;
import org.dom4j.tree.DefaultText;

public class XMLResourceGenerator {
    private static Map m_resources = new HashMap();
    private static LocaleFileManager m_file_manager = null;
    private static Object m_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XMLResource getResource(Locale locale) {
        XMLResource resource = null;
        Vector names = XMLResourceGenerator.calculateBundleNames("ncmsgrt", locale);
        Object object = m_lock;
        synchronized (object) {
            if (m_resources.containsKey(names.lastElement())) {
                resource = (XMLResource)m_resources.get(names.lastElement());
            } else {
                XMLResource rootResource;
                if (m_file_manager == null) {
                    m_file_manager = new LocaleFileManager();
                }
                if ((rootResource = (XMLResource)m_resources.get("ncmsgrt")) == null) {
                    File rootFile = m_file_manager.getRootLanguageFile();
                    rootResource = XMLResourceGenerator.getResource(null, rootFile);
                    m_resources.put("ncmsgrt", rootResource);
                }
                if (names.size() == 0) {
                    resource = rootResource;
                } else {
                    XMLResource parent = rootResource;
                    for (int i = 0; i < names.size(); ++i) {
                        if (m_resources.containsKey(names.get(i))) {
                            resource = parent = (XMLResource)m_resources.get(names.get(i));
                            continue;
                        }
                        File resourceFile = m_file_manager.getLanguageFile((String)names.get(i));
                        if (resourceFile == null) continue;
                        resource = XMLResourceGenerator.getResource(parent, resourceFile);
                        m_resources.put(names.get(i), resource);
                        parent = resource;
                    }
                }
            }
            m_lock.notify();
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static XMLResource getResource(XMLResource parent, File file) {
        XMLResource resource;
        block29: {
            resource = null;
            FileInputStream stream = null;
            stream = new FileInputStream(file);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)stream);
            Element root = doc.getRootElement();
            List messages = root.selectNodes("//message_type");
            Iterator itr = messages.iterator();
            resource = new XMLResource(parent);
            while (itr.hasNext()) {
                Element message = (Element)itr.next();
                Element code = message.element("code");
                Element text = message.element("text");
                String key = code.getText();
                String value = "";
                if (text.hasMixedContent()) {
                    StringBuffer buffer = new StringBuffer();
                    List bits = text.content();
                    for (Object next : bits) {
                        DefaultElement def;
                        if (next instanceof DefaultElement) {
                            def = (DefaultElement)next;
                            Attribute attr = def.attribute(0);
                            if (attr.getValue().endsWith("a")) {
                                buffer.append("{0}");
                                continue;
                            }
                            if (attr.getValue().endsWith("b")) {
                                buffer.append("{1}");
                                continue;
                            }
                            if (attr.getValue().endsWith("c")) {
                                buffer.append("{2}");
                                continue;
                            }
                            if (attr.getValue().endsWith("d")) {
                                buffer.append("{3}");
                                continue;
                            }
                            if (attr.getValue().endsWith("e")) {
                                buffer.append("{4}");
                                continue;
                            }
                            if (!attr.getValue().endsWith("f")) continue;
                            buffer.append("{5}");
                            continue;
                        }
                        if (next instanceof DefaultText) {
                            def = (DefaultText)next;
                            buffer.append(def.getText());
                            continue;
                        }
                        if (!(next instanceof DefaultEntity)) continue;
                        def = (DefaultEntity)next;
                        buffer.append(def.getText());
                    }
                    value = buffer.toString();
                } else {
                    value = text.getText();
                }
                resource.setString(key, value);
            }
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
                break block29;
            }
            catch (IOException e1) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e1);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e1.getMessage() + ""});
            }
            break block29;
            catch (DocumentException e) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e.getMessage() + ""});
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e1) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e1);
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e1.getMessage() + ""});
                }
            }
            catch (FileNotFoundException e) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e.getMessage() + ""});
                {
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                        catch (IOException e1) {
                            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e1);
                            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e1.getMessage() + ""});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e1) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e1);
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e1.getMessage() + ""});
                }
            }
        }
        return resource;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }
}

