/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.ConnectionOpener;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.exception.ExceptionUtils;

class ConnectionConfiguration {
    private String m_url;
    private String m_username;
    private String m_password;
    private boolean m_shouldHoldCursor = false;
    private ConnectionOpener m_connectionOpener;
    private int m_writableIsolation;
    private int m_readOnlyIsolation;
    private String m_checkSqlstmt = "SELECT 1 FROM NC_CTMAP WHERE 2 > 1";

    ConnectionConfiguration(JDBCConnectionProperties connectionProperties, ConnectionOpener connectionOpener) throws SQLException {
        this.m_url = connectionProperties.getUrlStr();
        this.m_username = connectionProperties.getLogId();
        this.m_password = connectionProperties.getPassword();
        DatabaseType dbType = connectionProperties.getDBType();
        if (DatabaseType.INFORMIX.equals(dbType)) {
            this.m_shouldHoldCursor = true;
        }
        this.m_writableIsolation = connectionProperties.getReadWriteIsolationLevel();
        this.m_readOnlyIsolation = connectionProperties.getReadOnlyIsolationLevel();
        this.m_connectionOpener = connectionOpener;
        this.m_checkSqlstmt = connectionProperties.getCheckConnectionStatement();
    }

    public String getCheckSqlstmt() {
        return this.m_checkSqlstmt;
    }

    public boolean shouldHoldCursor() {
        return this.m_shouldHoldCursor;
    }

    public int getIsolation(boolean readOnly) {
        if (readOnly) {
            return this.m_readOnlyIsolation;
        }
        return this.m_writableIsolation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getNewConnection() throws SQLException {
        Connection connection = null;
        try {
            return this.m_connectionOpener.openConnection(this.m_url, this.m_username, this.m_password);
        }
        catch (SQLException e) {
            String msg = "Error connecting to the database, some services may not work properly. Check the logs for further details.";
            ConnectionConfiguration.logFatalError(msg, e);
            ConnectionConfiguration.logExceptionWithStackTrace(e);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Waiting for connection");
            Class<JDBCConnection> clazz = JDBCConnection.class;
            synchronized (JDBCConnection.class) {
                while (true) {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        connection = this.m_connectionOpener.openConnection(this.m_url, this.m_username, this.m_password);
                        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Got Connection");
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return connection;
                    }
                    catch (SQLException e2) {
                        try {
                            ConnectionConfiguration.logExceptionWithStackTrace(e2);
                            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, null, new Object[]{"Can't reach DB will sleep 5 seconds and try again"});
                            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, null, new Object[]{e.getMessage()});
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                            continue;
                        }
                    }
                    break;
                }
            }
        }
    }

    static void logExceptionWithStackTrace(SQLException e) {
        SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, e);
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    private static void logFatalError(String msg, Exception e) {
        try {
            AuditProperties props = new AuditProperties("Run", e.getMessage(), msg, "Failure");
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, props);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

