/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConnectionOpener {
    private static Map<String, Driver> registeredDrivers = new HashMap<String, Driver>();
    private Driver m_driver;

    public static void registerDriver(Driver driver) throws SQLException {
        registeredDrivers.put(driver.getClass().getName(), driver);
        DriverManager.registerDriver(driver);
    }

    public static boolean canLoadDriver(String strDriver, String url) {
        boolean canLoadDriver = false;
        try {
            Driver driver = ConnectionOpener.loadDriver(strDriver, url);
            if (driver != null && driver.acceptsURL(url)) {
                canLoadDriver = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return canLoadDriver;
    }

    public ConnectionOpener(String strDriver, String url) throws ConnectionException {
        this.m_driver = ConnectionOpener.loadDriver(strDriver, url);
        try {
            if (!this.m_driver.acceptsURL(url)) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_INCORRECT_URL_EXCP, new String[]{url, strDriver});
                throw new ConnectionException(I18NCode.MSG_INCORRECT_URL_EXCP, new Object[]{url, strDriver});
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_JDBC_REGISTER_EXCP, new String[]{ex.getMessage() + ""});
            throw new ConnectionException(I18NCode.MSG_JDBC_REGISTER_EXCP, new Object[]{strDriver});
        }
    }

    public Connection openConnection(String url, String username, String password) throws SQLException {
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (password != null) {
            info.put("password", password);
        }
        return this.m_driver.connect(url, info);
    }

    private static Driver loadDriver(String driverString, String url) throws ConnectionException {
        Driver driver = null;
        try {
            try {
                driver = DriverManager.getDriver(url);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (driver == null && registeredDrivers.containsKey(driverString)) {
                driver = registeredDrivers.get(driverString);
            }
            if (driver == null) {
                Collection<Driver> ourDrivers = registeredDrivers.values();
                for (Driver oneDriver : ourDrivers) {
                    if (!oneDriver.acceptsURL(url)) continue;
                    driver = oneDriver;
                }
            }
            if (driver == null) {
                driver = (Driver)Class.forName(driverString).newInstance();
            }
        }
        catch (ClassNotFoundException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_CLASSNOTF_EXCP, new String[]{driverString});
            throw new ConnectionException(I18NCode.MSG_CLASSNOTF_EXCP, new Object[]{driverString});
        }
        catch (IllegalAccessException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_ACCESSRIGHT_EXCP, new String[]{driverString});
            throw new ConnectionException(I18NCode.MSG_ACCESSRIGHT_EXCP, new Object[]{driverString});
        }
        catch (InstantiationException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_CREATE_EXCP, new String[]{driverString});
            throw new ConnectionException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{driverString});
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_JDBC_REGISTER_EXCP, new String[]{ex.getMessage() + ""});
            throw new ConnectionException(I18NCode.MSG_JDBC_REGISTER_EXCP, new Object[]{driverString});
        }
        catch (ExceptionInInitializerError ex) {
            Throwable nested = ex.getException();
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_CREATE_EXCP, new String[]{driverString});
            throw new ConnectionException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{driverString});
        }
        catch (Throwable ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_OBJECT_CREATE_EXCP, new String[]{driverString});
            throw new ConnectionException(I18NCode.MSG_OBJECT_CREATE_EXCP, new Object[]{driverString});
        }
        return driver;
    }

    public String toString() {
        return this.m_driver.toString();
    }
}

