/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.ConnectionConfiguration;
import com.cognos.jsmcommon.jdbc.JDBCPreparedStatement;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class JDBCConnection
implements Connection {
    private Connection m_con;
    private boolean m_isInit = false;
    private String m_checkSqlstmt;
    private boolean m_hasException = false;

    public boolean isInit() {
        return this.m_isInit;
    }

    public void handleException(SQLException exception) {
        if (!this.m_hasException) {
            this.m_hasException = true;
            ConnectionConfiguration.logExceptionWithStackTrace(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFatalException() {
        if (!this.m_hasException) {
            return false;
        }
        this.m_hasException = false;
        boolean isConnectionOk = false;
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCConnection.hasFatalException");
        try {
            isConnectionOk = this.isConnectionOK();
            zipiTimer.setObjectPath(Boolean.toString(!isConnectionOk));
            boolean bl = !isConnectionOk;
            return bl;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionOK() {
        Statement stmt;
        ResultSet rs;
        boolean result;
        block4: {
            result = false;
            rs = null;
            stmt = null;
            try {
                if (this.m_con.isClosed()) break block4;
                stmt = this.m_con.createStatement();
                rs = stmt.executeQuery(this.m_checkSqlstmt);
                result = true;
            }
            catch (SQLException ex) {
                try {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_COULD_NOT_INIT_CONNECTIONS, new String[]{"1"});
                }
                catch (Throwable throwable) {
                    SqlResourceCloser.closeResources(rs, stmt);
                    throw throwable;
                }
                SqlResourceCloser.closeResources(rs, stmt);
            }
        }
        SqlResourceCloser.closeResources(rs, stmt);
        return result;
    }

    public void mock_init(Connection connection) throws SQLException {
        this.m_con = connection;
        this.m_isInit = true;
    }

    public void init(JDBCConnection con) {
        this.m_con = con.m_con;
        this.m_checkSqlstmt = con.m_checkSqlstmt;
        this.m_hasException = false;
        this.m_isInit = true;
    }

    public void init(ConnectionConfiguration conf) throws SQLException {
        this.createConnection(conf);
        this.checkForInformix(conf);
        this.m_checkSqlstmt = conf.getCheckSqlstmt();
        this.m_isInit = true;
    }

    private void checkForInformix(ConnectionConfiguration conf) throws SQLException {
        if (conf.shouldHoldCursor()) {
            this.m_con.setHoldability(1);
        }
    }

    private void createConnection(ConnectionConfiguration conf) throws SQLException {
        ZipiTimer timer = ZipiBridge.startTimer("JDBCConnection.createConnection");
        try {
            this.m_con = conf.getNewConnection();
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.m_con.clearWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.m_con != null) {
            this.m_con.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.m_con.commit();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.m_con.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.m_con.createBlob();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.m_con.createClob();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.m_con.createNClob();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.m_con.createSQLXML();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.m_con.createStatement();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.m_con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.m_con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            return this.m_con.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.m_con.getAutoCommit();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.m_con.getCatalog();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.m_con.getClientInfo();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.m_con.getClientInfo(name);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.m_con.getHoldability();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.m_con.getMetaData();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.m_con.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.m_con.getTypeMap();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.m_con.getWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_con.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.m_con.isReadOnly();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.m_con.isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCConnection.nativeSQL");
        zipiTimer.setObjectPath(sql);
        try {
            String string = this.m_con.nativeSQL(sql);
            return string;
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCConnection.prepareCall");
        zipiTimer.setObjectPath(sql);
        try {
            CallableStatement callableStatement = this.m_con.prepareCall(sql);
            return callableStatement;
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCConnection.prepareCall");
        zipiTimer.setObjectPath(sql);
        try {
            CallableStatement callableStatement = this.m_con.prepareCall(sql, resultSetType, resultSetConcurrency);
            return callableStatement;
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCConnection.prepareCall");
        zipiTimer.setObjectPath(sql);
        try {
            CallableStatement callableStatement = this.m_con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return callableStatement;
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return new JDBCPreparedStatement(this, this.m_con.prepareStatement(sql), sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return new JDBCPreparedStatement(this, this.m_con.prepareStatement(sql, autoGeneratedKeys), sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return new JDBCPreparedStatement(this, this.m_con.prepareStatement(sql, columnIndexes), sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return new JDBCPreparedStatement(this, this.m_con.prepareStatement(sql, columnNames), sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return new JDBCPreparedStatement(this, this.m_con.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return new JDBCPreparedStatement(this, this.m_con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.m_con.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.m_con.rollback();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.m_con.rollback(savepoint);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.m_con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.m_con.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.m_con.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.m_con.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.m_con.setHoldability(holdability);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.m_con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.m_con.setSavepoint();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this.m_con.setSavepoint(name);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.m_con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.m_con.setTypeMap(map);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.m_con.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.m_con.unwrap(iface);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("Not implemented! Need review for Java8 support!");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Not implemented! Need review for Java8 support!");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Not implemented! Need review for Java8 support!");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("Not implemented! Need review for Java8 support!");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Not implemented! Need review for Java8 support!");
    }
}

