/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.ConnectionConfiguration;
import com.cognos.jsmcommon.jdbc.ConnectionOpener;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.LockReleaseTracker;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.SQLException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class JDBCConnectionPool {
    private static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 300000L;
    private static final long DEFAULT_TIME_BETWEEN_EVICTITION_RUNS_MILLIS = 300000L;
    private static final int UNLIMITED = -1;
    private static final int TEST_PER_EVICT_RUN = -2;
    private GenericObjectPool m_connectionPool;
    private ConnectionConfiguration m_connectionConf;

    public JDBCConnectionPool(JDBCConnectionProperties connectionProperties, ConnectionOpener opener) throws SQLException {
        Integer maxCons = connectionProperties.getMaxConnections();
        Integer maxReadOnlyCons = connectionProperties.getMaxReadOnlyConnections();
        int maxConnection = Math.max(maxCons, maxReadOnlyCons);
        this.m_connectionPool = new GenericObjectPool((PoolableObjectFactory)new ConnectionFactory());
        if (maxConnection == -1) {
            this.m_connectionPool.setMaxActive(-1);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Connection Pool is set to UNLIMITED");
        } else {
            this.m_connectionPool.setMaxActive(maxConnection);
            this.m_connectionPool.setWhenExhaustedAction((byte)1);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Connection Pool is set to " + maxConnection);
        }
        this.m_connectionPool.setMaxIdle(-1);
        this.m_connectionPool.setMinEvictableIdleTimeMillis(300000L);
        this.m_connectionPool.setTimeBetweenEvictionRunsMillis(300000L);
        this.m_connectionPool.setTestOnBorrow(false);
        this.m_connectionPool.setTestOnReturn(false);
        this.m_connectionPool.setTestWhileIdle(false);
        this.m_connectionPool.setNumTestsPerEvictionRun(-2);
        this.m_connectionConf = new ConnectionConfiguration(connectionProperties, opener);
        LockReleaseTracker.setUseTracker(connectionProperties);
        JDBCConnection temp = this.getJDBCConnection(false, this.m_connectionConf.getIsolation(false));
        this.releaseConnection(temp);
    }

    public JDBCConnection getJDBCConnection(boolean readOnly, int transactionIsolation) throws SQLException {
        while (true) {
            JDBCConnection con = null;
            try {
                con = this.attemptConnectionCreation(readOnly, transactionIsolation);
                return con;
            }
            catch (SQLException sQLException) {
                continue;
            }
            break;
        }
    }

    private JDBCConnection attemptConnectionCreation(boolean readOnly, int transactionIsolation) throws SQLException {
        JDBCConnection con = null;
        try {
            con = this.getConnection();
            if (!con.isInit()) {
                con.init(this.m_connectionConf);
            }
            con.setTransactionIsolation(transactionIsolation);
            con.setAutoCommit(true);
            return con;
        }
        catch (SQLException e) {
            this.releaseConnection(con);
            throw e;
        }
    }

    public JDBCConnection getJDBCConnection(boolean readOnly) throws SQLException {
        return this.getJDBCConnection(readOnly, this.m_connectionConf.getIsolation(readOnly));
    }

    private JDBCConnection getConnection() throws SQLException {
        try {
            return (JDBCConnection)this.m_connectionPool.borrowObject();
        }
        catch (Exception e) {
            throw new SQLException("unable to borrow connection from pool", e);
        }
    }

    private void checkPool() {
        int idle = this.m_connectionPool.getNumIdle();
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Begin checkPool num idle connections " + idle);
        int active = this.m_connectionPool.getNumActive();
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Begin checkPool num active connections " + active);
        for (int i = 0; i < idle; ++i) {
            try {
                JDBCConnection connection = this.getConnection();
                if (connection.isInit() && connection.isConnectionOK()) {
                    this.m_connectionPool.returnObject((Object)connection);
                    break;
                }
                this.m_connectionPool.invalidateObject((Object)connection);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        idle = this.m_connectionPool.getNumIdle();
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("After checkPool num idle connections " + idle);
        active = this.m_connectionPool.getNumActive();
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("After checkPool num active connections " + active);
    }

    public void releaseConnection(JDBCConnection con) throws SQLException {
        if (null != con) {
            try {
                if (con.hasFatalException()) {
                    this.m_connectionPool.invalidateObject((Object)con);
                    this.checkPool();
                } else {
                    this.m_connectionPool.returnObject((Object)con);
                }
            }
            catch (Exception e) {
                throw new SQLException("unable to return connection to pool", e);
            }
        }
    }

    public void close() throws Exception {
        this.m_connectionPool.close();
    }

    private class ConnectionFactory
    extends BasePoolableObjectFactory {
        ConnectionFactory() {
        }

        public Object makeObject() throws Exception {
            return new JDBCConnection();
        }

        public void destroyObject(Object connection) throws Exception {
            try {
                ((JDBCConnection)connection).close();
            }
            catch (SQLException sqlex) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.SQL_RELEASE_ERROR);
            }
        }
    }
}

