/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class JDBCPreparedStatement
implements PreparedStatement {
    private JDBCConnection m_connection;
    private PreparedStatement m_statement;
    private String m_sql;

    public JDBCPreparedStatement(JDBCConnection connection, PreparedStatement statement, String sql) {
        this.m_connection = connection;
        this.m_statement = statement;
        this.m_sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.m_statement.addBatch();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.m_statement.clearParameters();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.execute");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            boolean bl = this.m_statement.execute();
            return bl;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeQuery");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            ResultSet resultSet = this.m_statement.executeQuery();
            return resultSet;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeUpdate");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            int n = this.m_statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.m_statement.getMetaData();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.m_statement.getParameterMetaData();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        try {
            this.m_statement.setArray(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        try {
            this.m_statement.setAsciiStream(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.m_statement.setAsciiStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        try {
            this.m_statement.setAsciiStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        try {
            this.m_statement.setBigDecimal(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        try {
            this.m_statement.setBinaryStream(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.m_statement.setBinaryStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        try {
            this.m_statement.setBinaryStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
        try {
            this.m_statement.setBlob(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        try {
            this.m_statement.setBlob(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        try {
            this.m_statement.setBlob(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        try {
            this.m_statement.setBoolean(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        try {
            this.m_statement.setByte(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        try {
            this.m_statement.setBytes(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        try {
            this.m_statement.setCharacterStream(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        try {
            this.m_statement.setCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.m_statement.setCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        try {
            this.m_statement.setClob(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        try {
            this.m_statement.setClob(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.m_statement.setClob(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        try {
            this.m_statement.setDate(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        try {
            this.m_statement.setDate(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        try {
            this.m_statement.setDouble(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        try {
            this.m_statement.setFloat(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        try {
            this.m_statement.setInt(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        try {
            this.m_statement.setLong(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        try {
            this.m_statement.setNCharacterStream(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.m_statement.setNCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        try {
            this.m_statement.setNClob(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        try {
            this.m_statement.setNClob(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.m_statement.setNClob(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        try {
            this.m_statement.setNString(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
        try {
            this.m_statement.setNull(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        try {
            this.m_statement.setNull(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setObject(int arg0, Object arg1) throws SQLException {
        try {
            this.m_statement.setObject(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        try {
            this.m_statement.setObject(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        try {
            this.m_statement.setObject(arg0, arg1, arg2, arg3);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setRef(int arg0, Ref arg1) throws SQLException {
        try {
            this.m_statement.setRef(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        try {
            this.m_statement.setRowId(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        try {
            this.m_statement.setSQLXML(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        try {
            this.m_statement.setShort(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        try {
            this.m_statement.setString(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        try {
            this.m_statement.setTime(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        try {
            this.m_statement.setTime(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        try {
            this.m_statement.setTimestamp(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        try {
            this.m_statement.setTimestamp(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
        try {
            this.m_statement.setURL(arg0, arg1);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.m_statement.setUnicodeStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        try {
            this.m_statement.addBatch(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.m_statement.cancel();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.m_statement.clearBatch();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.m_statement.clearWarnings();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.m_statement.close();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.execute");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            boolean bl = this.m_statement.execute(arg0);
            return bl;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.execute");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            boolean bl = this.m_statement.execute(arg0, arg1);
            return bl;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.execute");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            boolean bl = this.m_statement.execute(arg0, arg1);
            return bl;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.execute");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            boolean bl = this.m_statement.execute(arg0, arg1);
            return bl;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeBatch");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            int[] nArray = this.m_statement.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeQuery");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            ResultSet resultSet = this.m_statement.executeQuery(arg0);
            return resultSet;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeUpdate");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            int n = this.m_statement.executeUpdate(arg0);
            return n;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeUpdate");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            int n = this.m_statement.executeUpdate(arg0, arg1);
            return n;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeUpdate");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            int n = this.m_statement.executeUpdate(arg0, arg1);
            return n;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCPreparedStatement.executeUpdate");
        zipiTimer.setObjectPath(this.m_sql);
        try {
            int n = this.m_statement.executeUpdate(arg0, arg1);
            return n;
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.m_statement.getConnection();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.m_statement.getFetchDirection();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.m_statement.getFetchSize();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.m_statement.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.m_statement.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.m_statement.getMaxRows();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.m_statement.getMoreResults();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        try {
            return this.m_statement.getMoreResults(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.m_statement.getQueryTimeout();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.m_statement.getResultSet();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.m_statement.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.m_statement.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.m_statement.getResultSetType();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.m_statement.getUpdateCount();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.m_statement.getWarnings();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.m_statement.isClosed();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.m_statement.isPoolable();
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        try {
            this.m_statement.setCursorName(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        try {
            this.m_statement.setEscapeProcessing(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        try {
            this.m_statement.setFetchDirection(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        try {
            this.m_statement.setFetchSize(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        try {
            this.m_statement.setMaxFieldSize(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        try {
            this.m_statement.setMaxRows(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        try {
            this.m_statement.setPoolable(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        try {
            this.m_statement.setQueryTimeout(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        try {
            return this.m_statement.isWrapperFor(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        try {
            return this.m_statement.unwrap(arg0);
        }
        catch (SQLException e) {
            this.m_connection.handleException(e);
            throw e;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Not implemented! Need review for Java8 support!");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Not implemented! Need review for Java8 support!");
    }
}

