/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.ConnectionOpener;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.JDBCConnectionPool;
import com.cognos.jsmcommon.jdbc.ObjectIdConnection;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import java.sql.SQLException;

public final class KeepConnectionFactory
implements AbstractFactory {
    JDBCConnectionPool m_connectionPool;

    KeepConnectionFactory(JDBCConnectionProperties connectionProperties, ConnectionOpener opener) throws SQLException {
        this.m_connectionPool = new JDBCConnectionPool(connectionProperties, opener);
    }

    @Override
    public JDBCConnection createReadOnlyConnection(int transactionIsolation) throws SQLException {
        return this.m_connectionPool.getJDBCConnection(true, transactionIsolation);
    }

    @Override
    public JDBCConnection createReadOnlyConnection() throws SQLException {
        return this.m_connectionPool.getJDBCConnection(true);
    }

    @Override
    public JDBCConnection createConnection(int transactionIsolation) throws SQLException {
        return this.m_connectionPool.getJDBCConnection(false, transactionIsolation);
    }

    @Override
    public JDBCConnection createConnection() throws SQLException {
        return this.m_connectionPool.getJDBCConnection(false);
    }

    @Override
    public void releaseConnection(JDBCConnection connection) throws SQLException {
        if (null != connection) {
            this.m_connectionPool.releaseConnection(connection);
        }
    }

    @Override
    public JDBCConnection createConnection(ObjectIdConnection caller) throws SQLException {
        return this.m_connectionPool.getJDBCConnection(false);
    }

    @Override
    public void close() {
        try {
            this.m_connectionPool.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

