/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.ConnectionOpener;
import com.cognos.jsmcommon.jdbc.KeepConnectionFactory;
import com.cognos.jsmcommon.jdbc.OpenCloseConnectionFactory;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.SQLException;

public final class NCConnection {
    private AbstractFactory mFactory = null;
    private static volatile NCConnection mInstance = null;
    private static volatile NCConnection mHTSInstance = null;
    private JDBCConnectionProperties prop_instance;
    private ConnectionOpener mConnectionOpener;

    public AbstractFactory getConnectionFactory() {
        return this.mFactory;
    }

    public AbstractFactory getOpenCloseFactory() {
        return new OpenCloseConnectionFactory(this.mConnectionOpener, this.prop_instance);
    }

    private NCConnection(boolean enforceOpenClose, String component) throws ConnectionException {
        this.registerDriver(component);
        this.createConnectionFactory(enforceOpenClose, component);
    }

    private void createConnectionFactory(boolean enforceOpenClose, String COMPONENT) throws ConnectionException {
        boolean keepOpen = false;
        this.prop_instance = JDBCConnectionProperties.instance(COMPONENT);
        if (this.prop_instance != null) {
            keepOpen = this.prop_instance.getKeepOpen();
        }
        if (enforceOpenClose || !keepOpen) {
            this.mFactory = new OpenCloseConnectionFactory(this.prop_instance, this.mConnectionOpener);
            if (this.mFactory == null) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("could not create a database connection factory");
            }
        } else {
            try {
                this.mFactory = new KeepConnectionFactory(this.prop_instance, this.mConnectionOpener);
                if (this.mFactory == null) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("could not create a keep-connection database connection factory");
                }
            }
            catch (SQLException ex) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_DATASTORE_URL_EXCP, new String[]{this.prop_instance.getUrlStr()});
                throw new ConnectionException(I18NCode.MSG_DATASTORE_URL_EXCP, new Object[]{this.prop_instance.getUrlStr()});
            }
        }
        if (this.mFactory == null) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_DATASTORE_URL_EXCP, new String[]{this.prop_instance.getUrlStr()});
            throw new ConnectionException(I18NCode.MSG_DATASTORE_URL_EXCP, new Object[]{this.prop_instance.getUrlStr()});
        }
    }

    public void reset() throws ConnectionException {
        this.createConnectionFactory(false, null);
    }

    public static void resetInstance() {
        mInstance = null;
        mHTSInstance = null;
    }

    private void registerDriver(String component) throws ConnectionException {
        String driver = JDBCConnectionProperties.instance(component).getDriverStr();
        String url = JDBCConnectionProperties.instance(component).getUrlStr();
        if (driver == null || driver.trim().length() <= 0) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_NODRIVER_EXCP);
            throw new ConnectionException(I18NCode.MSG_NODRIVER_EXCP);
        }
        if (url == null || url.trim().length() <= 0) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_URLDEF_EXCP);
            throw new ConnectionException(I18NCode.MSG_URLDEF_EXCP);
        }
        this.mConnectionOpener = new ConnectionOpener(driver, url);
    }

    public static NCConnection instance() {
        return NCConnection.getInstance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NCConnection instance(String connectionType) {
        if (!"HTS".equals(connectionType)) return NCConnection.getInstance(false);
        NCConnection result = mHTSInstance;
        if (result != null) return result;
        Class<NCConnection> clazz = NCConnection.class;
        synchronized (NCConnection.class) {
            result = mHTSInstance;
            if (result != null) return result;
            try {
                mHTSInstance = result = new NCConnection(false, "HTS");
            }
            catch (ConnectionException ex) {
                String errMsg = ex.getMessage() + "";
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM, new String[]{errMsg});
                throw new IllegalStateException(errMsg);
            }
            return result;
        }
    }

    public static NCConnection enforcedInstance() {
        return NCConnection.getInstance(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void releaseAll() {
        if (mInstance == null && mHTSInstance == null) return;
        Class<NCConnection> clazz = NCConnection.class;
        synchronized (NCConnection.class) {
            if (this.mFactory instanceof KeepConnectionFactory) {
                KeepConnectionFactory factory = (KeepConnectionFactory)this.mFactory;
                factory.close();
            }
            this.mFactory = null;
            mInstance = null;
            mHTSInstance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NCConnection getInstance(boolean enforceOpenClose) {
        NCConnection result = mInstance;
        if (result != null) return result;
        Class<NCConnection> clazz = NCConnection.class;
        synchronized (NCConnection.class) {
            result = mInstance;
            if (result != null) return result;
            try {
                mInstance = result = new NCConnection(enforceOpenClose, null);
            }
            catch (ConnectionException ex) {
                String errMsg = ex.getMessage() + "";
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_SQL_ERROR_UNABLE_TO_GET_CONNECTION_FROM, new String[]{errMsg});
                throw new IllegalStateException(errMsg);
            }
            return result;
        }
    }
}

