/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.ConnectionConfiguration;
import com.cognos.jsmcommon.jdbc.ConnectionOpener;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.ObjectIdConnection;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.SQLException;

public class OpenCloseConnectionFactory
implements AbstractFactory {
    private ConnectionConfiguration mConnectionConf;

    public OpenCloseConnectionFactory(ConnectionOpener connectionOpener, JDBCConnectionProperties connectionProperties) {
        try {
            this.mConnectionConf = new ConnectionConfiguration(connectionProperties, connectionOpener);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public OpenCloseConnectionFactory(JDBCConnectionProperties connectionProperties, ConnectionOpener connectionOpener) {
        this(connectionOpener, connectionProperties);
    }

    @Override
    public JDBCConnection createReadOnlyConnection() throws SQLException {
        return this.createConnection(this.mConnectionConf.getIsolation(true));
    }

    @Override
    public JDBCConnection createReadOnlyConnection(int transactionIsolation) throws SQLException {
        return this.createConnection(transactionIsolation);
    }

    @Override
    public JDBCConnection createConnection(ObjectIdConnection caller) throws SQLException {
        return this.createConnection();
    }

    @Override
    public JDBCConnection createConnection(int transactionIsolation) throws SQLException {
        JDBCConnection theConn = new JDBCConnection();
        theConn.init(this.mConnectionConf);
        theConn.setTransactionIsolation(transactionIsolation);
        return theConn;
    }

    @Override
    public JDBCConnection createConnection() throws SQLException {
        return this.createConnection(this.mConnectionConf.getIsolation(false));
    }

    @Override
    public void releaseConnection(JDBCConnection connection) throws SQLException {
        if (connection == null) {
            return;
        }
        if (connection.isClosed()) {
            String errMsg = "a closed connection is called to be closed";
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, null, new String[]{errMsg});
        } else {
            connection.close();
        }
    }

    @Override
    public void close() throws SQLException {
    }
}

