/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.SJDBCResourceContainer;
import com.cognos.jsmcommon.jdbc.SResourceProxyFactory;
import com.cognos.jsmcommon.jdbc.SStatementHolder;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public final class SAdaptorConnection
implements InvocationHandler {
    private Connection m_adaptee;
    private boolean m_isReadOnly;
    private SStatementHolder m_holder;

    public SAdaptorConnection(boolean readOnly, Connection adaptee) throws SQLException {
        this.m_adaptee = adaptee;
        this.m_isReadOnly = readOnly;
        this.m_holder = SJDBCResourceContainer.register(this);
    }

    boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public Statement createStatement() throws SQLException {
        Statement result = this.m_adaptee.createStatement();
        result = SResourceProxyFactory.getSStatement(this.m_holder, result, this.m_isReadOnly);
        this.m_holder.addStatement(result);
        return result;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement result = null;
        PreparedStatement ps = this.m_adaptee.prepareStatement(sql);
        result = SResourceProxyFactory.getSPreparedStatement(this.m_holder, sql, ps, this.m_isReadOnly);
        this.m_holder.addPrepearedStatement(result);
        return result;
    }

    public void close() throws SQLException {
        SJDBCResourceContainer.unregister(this);
        this.m_adaptee.close();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("setReadOnly is called, " + readOnly);
        this.m_adaptee.setReadOnly(readOnly);
    }

    private int[] getIntValue(Object[] objArray, int startIndex) {
        int[] result = new int[objArray.length];
        for (int counter = startIndex; counter < objArray.length; ++counter) {
            result[counter] = objArray[counter] instanceof Integer ? (Integer)objArray[counter] : Array.getInt(objArray, counter);
        }
        return result;
    }

    private Statement createStatement(Object[] array) throws SQLException {
        Statement result = null;
        int[] parameters = this.getIntValue(array, 0);
        result = this.createStatement(parameters[0], parameters[1]);
        return result;
    }

    private Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement result = this.m_adaptee.createStatement(resultSetType, resultSetConcurrency);
        result = SResourceProxyFactory.getSStatement(this.m_holder, result, this.m_isReadOnly);
        this.m_holder.addStatement(result);
        return result;
    }

    private PreparedStatement prepareStatement(Object[] array) throws SQLException {
        PreparedStatement result = null;
        String sql = (String)array[0];
        int[] args = this.getIntValue(array, 1);
        result = this.prepareStatement(sql, args[1], args[2]);
        return result;
    }

    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement result = null;
        PreparedStatement ps = this.m_adaptee.prepareStatement(sql, resultSetType, resultSetConcurrency);
        result = SResourceProxyFactory.getSPreparedStatement(this.m_holder, sql, ps, this.m_isReadOnly);
        this.m_holder.addPrepearedStatement(result);
        return result;
    }

    public int hashCode() {
        return this.m_adaptee.hashCode();
    }

    public boolean equals(Object o) {
        boolean result = false;
        Object obj = o;
        if (Proxy.isProxyClass(obj.getClass())) {
            obj = Proxy.getInvocationHandler(obj);
        }
        if (obj != null && obj instanceof SAdaptorConnection) {
            SAdaptorConnection otherAC = (SAdaptorConnection)obj;
            Connection otherConn = otherAC.m_adaptee;
            result = this.m_adaptee.equals(otherConn);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<Void> result = null;
        try {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                boolean tmpBoolean = this.equals(args[0]);
                return tmpBoolean ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("createStatement")) {
                if (args == null) return this.createStatement();
                if (args.length == 0) {
                    return this.createStatement();
                }
                if (args.length == 2) {
                    return this.createStatement(args);
                }
                String errMsg = "createStatement with " + args.length + " parameters is not supported";
                throw new UnsupportedOperationException();
            }
            if (methodName.equals("prepareStatement")) {
                if (args.length == 1) {
                    String sql = (String)Array.get(args, 0);
                    return this.prepareStatement(sql);
                }
                if (args.length == 3) {
                    return this.prepareStatement(args);
                }
                String errMsg = "prepareStatement with " + args.length + " parameters is not supported";
                throw new UnsupportedOperationException();
            }
            if (methodName.equals("close") && (args == null || args.length == 0)) {
                this.close();
                return Void.TYPE;
            }
            if (!methodName.equals("setReadOnly")) return method.invoke((Object)this.m_adaptee, args);
            if (args.length != 1) return method.invoke((Object)this.m_adaptee, args);
            boolean readOnly = Array.getBoolean(args, 0);
            this.setReadOnly(readOnly);
            return Void.TYPE;
        }
        catch (InvocationTargetException ex) {
            SQLException sqlExcp = null;
            Throwable t = ex.getTargetException();
            sqlExcp = t instanceof SQLException ? (SQLException)t : new SQLException(t.getMessage());
            throw sqlExcp;
        }
        catch (Throwable t) {
            throw t;
        }
    }

    public SStatementHolder getHolder() {
        return this.m_holder;
    }

    public void setHolder(SStatementHolder holder) {
        this.m_holder = holder;
    }
}

