/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.LockReleaseTracker;
import com.cognos.jsmcommon.jdbc.SAdaptorBaseStatement;
import com.cognos.jsmcommon.jdbc.SPSElement;
import com.cognos.jsmcommon.jdbc.SResourceProxyFactory;
import com.cognos.jsmcommon.jdbc.SStatementHolder;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.Debug;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class SAdaptorPreparedStatement
extends SAdaptorBaseStatement
implements InvocationHandler {
    private int m_executionCounter = 0;
    private PreparedStatement m_ps;
    private String m_sqlStr;
    private ArrayList m_indexValues;
    private boolean m_isReadOnly;
    private String[] m_unsupportedMethods = new String[0];
    private String[] m_twoArgMethods = new String[]{"setArray", "setBigDecimal", "setBlob", "setBoolean", "setByte", "setClob", "setDate", "setDouble", "setFloat", "setInt", "setLong", "setNull", "setShort", "setString", "setTime", "setTimestamp"};
    private String[] m_threeArgMethods = new String[]{"setAsciiStream", "setBinaryStream", "setCharacterStream"};
    private WeakReference m_holder;

    public SAdaptorPreparedStatement(SStatementHolder holder, String sqlStr, PreparedStatement ps, boolean isReadOnly) {
        this.m_ps = ps;
        this.m_sqlStr = new String(sqlStr);
        this.m_indexValues = new ArrayList();
        this.m_isReadOnly = isReadOnly;
        this.m_holder = new WeakReference<SStatementHolder>(holder);
        SAdaptorPreparedStatement.logStatementOpened("PREPARED STATEMENT " + this.m_ps, this.m_isReadOnly);
    }

    public int hashCode() {
        return this.m_ps.hashCode();
    }

    public boolean equals(Object o) {
        boolean result = false;
        Object obj = o;
        if (Proxy.isProxyClass(obj.getClass())) {
            obj = Proxy.getInvocationHandler(obj);
        }
        if (obj != null && obj instanceof SAdaptorPreparedStatement) {
            SAdaptorPreparedStatement otherAPS = (SAdaptorPreparedStatement)obj;
            PreparedStatement otherPS = otherAPS.m_ps;
            result = this.m_ps.equals(otherPS);
        }
        return result;
    }

    public ResultSet executeQuery() throws SQLException {
        this.printInfo();
        ResultSet result = this.m_ps.executeQuery();
        SStatementHolder holder = (SStatementHolder)this.m_holder.get();
        result = SResourceProxyFactory.getSResultSet(result, holder);
        if (holder != null) {
            holder.addResultSet(result);
        }
        return result;
    }

    public int executeUpdate() throws SQLException {
        if (Debug.checkConstraints && this.m_isReadOnly) {
            String errMsg = "A read only prepared statement is used for \"" + this.m_sqlStr + "\"";
            throw new IllegalStateException(errMsg);
        }
        this.printInfo();
        return this.m_ps.executeUpdate();
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.m_ps.setAsciiStream(parameterIndex, x, length);
        if (Debug.debug) {
            this.m_indexValues.add(new SPSElement(parameterIndex, "AsciiStream; " + length));
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.m_ps.setBinaryStream(parameterIndex, x, length);
        if (Debug.debug) {
            this.m_indexValues.add(new SPSElement(parameterIndex, "BinaryStream; " + length));
        }
    }

    public boolean execute() throws SQLException {
        this.printInfo();
        return this.m_ps.execute();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.m_ps.setCharacterStream(parameterIndex, reader, length);
        if (Debug.debug) {
            this.m_indexValues.add(new SPSElement(parameterIndex, "CharacterStream; " + length));
        }
    }

    public void close() throws SQLException {
        SAdaptorPreparedStatement.logStatementClosed("PREPARED STATEMENT " + this.m_ps, this.m_isReadOnly);
        SStatementHolder holder = (SStatementHolder)this.m_holder.get();
        if (holder != null) {
            holder.removePreparedStatement(this);
        } else {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("failed to get holder for " + this.m_sqlStr);
        }
        holder.checkResultSets();
        this.m_ps.close();
    }

    private void setString(Object[] args) throws SQLException {
        if (args == null || args.length != 2) {
            String errMsg = "setString with " + (args == null ? "no" : Integer.toString(args.length)) + " parameters is not supported by CNC";
            throw new UnsupportedOperationException(errMsg);
        }
        int parameterIndex = 0;
        parameterIndex = args[0].getClass().isPrimitive() ? Array.getInt(args, 0) : (Integer)args[0];
        String value = (String)args[1];
        this.m_ps.setString(parameterIndex, value);
        this.m_indexValues.add(new SPSElement(parameterIndex, value));
    }

    private void printInfo() {
        ++this.m_executionCounter;
        if (!LockReleaseTracker.useTracker) {
            return;
        }
        String newLine = System.getProperty("line.separator");
        StringBuffer info = new StringBuffer("PREPARED STATEMENT ");
        info.append("is executed ");
        info.append(this.m_executionCounter);
        info.append(" times = ");
        info.append(this.m_sqlStr);
        info.append(newLine);
        Iterator elements = this.m_indexValues.iterator();
        SPSElement oneElm = null;
        Object oneIndex = null;
        while (elements.hasNext()) {
            oneElm = (SPSElement)elements.next();
            info.append("\t");
            info.append(oneElm);
            info.append(newLine);
        }
        this.m_indexValues.clear();
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(info.toString());
    }

    public String toString() {
        return this.m_sqlStr + " is executed " + this.m_executionCounter + " times.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        try {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                boolean tmpBoolean = this.equals(args[0]);
                return tmpBoolean ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("execute")) {
                if (args == null || args.length == 0) {
                    boolean value = this.execute();
                    return value ? Boolean.TRUE : Boolean.FALSE;
                }
                String errMsg = "execute with " + args.length + " parameters is not supported by CNC";
                throw new UnsupportedOperationException(errMsg);
            }
            if (methodName.equals("executeQuery")) {
                if (args == null) return this.executeQuery();
                if (args.length == 0) {
                    return this.executeQuery();
                }
                String errMsg = "executeQuery with " + args.length + " parameters is not supported by CNC";
                throw new UnsupportedOperationException(errMsg);
            }
            if (methodName.equals("executeUpdate")) {
                if (args == null || args.length == 0) {
                    int rows = this.executeUpdate();
                    return new Integer(rows);
                }
                String errMsg = "executeUpdate with " + args.length + " parameters is not supported by CNC";
                throw new UnsupportedOperationException(errMsg);
            }
            if (methodName.equals("close")) {
                if (args == null || args.length == 0) {
                    this.close();
                    return Void.TYPE;
                }
                String errMsg = "close with " + args.length + " parameters is not supported by CNC";
                throw new UnsupportedOperationException(errMsg);
            }
            if (methodName.equals("setString")) {
                this.setString(args);
                return Void.TYPE;
            }
            if (Arrays.binarySearch(this.m_unsupportedMethods, methodName) >= 0) {
                String errMsg = "executing " + methodName + " is not supported by CNC";
                throw new UnsupportedOperationException(errMsg);
            }
            if (Arrays.binarySearch(this.m_twoArgMethods, methodName) >= 0) {
                result = method.invoke((Object)this.m_ps, args);
                SPSElement elem = new SPSElement(args, 2);
                this.m_indexValues.add(elem);
                return result;
            }
            if (Arrays.binarySearch(this.m_threeArgMethods, methodName) >= 0) {
                result = method.invoke((Object)this.m_ps, args);
                SPSElement elem = new SPSElement(args, 3);
                this.m_indexValues.add(elem);
                return result;
            }
            if (!methodName.equals("toString")) return method.invoke((Object)this.m_ps, args);
            return this.toString();
        }
        catch (InvocationTargetException ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(System.currentTimeMillis() + " " + Thread.currentThread().getName() + " caused ps error");
            SQLException sqlExcp = null;
            Throwable t = ex.getTargetException();
            sqlExcp = t instanceof SQLException ? (SQLException)t : new SQLException(t.getMessage());
            throw sqlExcp;
        }
        catch (Throwable t) {
            throw t;
        }
    }
}

