/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.SStatementHolder;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SAdaptorResultSet
implements InvocationHandler {
    private static int m_rs_count;
    private ResultSet m_rs;
    private WeakReference holderRef = null;

    public SAdaptorResultSet(ResultSet realRS, SStatementHolder holder) {
        this.m_rs = realRS;
        this.holderRef = new WeakReference<SStatementHolder>(holder);
        ++m_rs_count;
    }

    public int hashCode() {
        return this.m_rs.hashCode();
    }

    public boolean equals(Object o) {
        boolean result = false;
        Object obj = o;
        if (Proxy.isProxyClass(obj.getClass())) {
            obj = Proxy.getInvocationHandler(obj);
        }
        if (obj != null && obj instanceof SAdaptorResultSet) {
            SAdaptorResultSet srs = (SAdaptorResultSet)obj;
            result = this.m_rs.equals(srs.m_rs);
        }
        return result;
    }

    public void close() throws SQLException {
        this.m_rs.close();
        --m_rs_count;
        SStatementHolder holder = (SStatementHolder)this.holderRef.get();
        if (holder != null) {
            holder.removeResultSet(this);
        }
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("open result sets: " + m_rs_count);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<Void> result = null;
        try {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                boolean tmpBoolean = this.equals(args[0]);
                return tmpBoolean ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!methodName.equals("close")) return method.invoke((Object)this.m_rs, args);
            if (args == null || args.length == 0) {
                this.close();
                return Void.TYPE;
            }
            String errMsg = "close with " + args.length + " parameters is not supported by CNC";
            throw new UnsupportedOperationException(errMsg);
        }
        catch (InvocationTargetException ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(System.currentTimeMillis() + " " + Thread.currentThread().getName() + " caused rs error");
            SQLException sqlExcp = null;
            Throwable t = ex.getTargetException();
            sqlExcp = t instanceof SQLException ? (SQLException)t : new SQLException(t.getMessage());
            throw sqlExcp;
        }
        catch (Throwable t) {
            throw t;
        }
    }
}

