/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.LockReleaseTracker;
import com.cognos.jsmcommon.jdbc.SAdaptorBaseStatement;
import com.cognos.jsmcommon.jdbc.SResourceProxyFactory;
import com.cognos.jsmcommon.jdbc.SStatementHolder;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.Debug;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public final class SAdaptorStatement
extends SAdaptorBaseStatement
implements InvocationHandler {
    private Statement m_stmt;
    private boolean m_isReadOnly;
    private ArrayList m_sqlStrList;
    private WeakReference m_holder;

    public SAdaptorStatement(SStatementHolder holder, Statement stmt, boolean isReadOnly) {
        this.m_stmt = stmt;
        this.m_isReadOnly = isReadOnly;
        SAdaptorStatement.logStatementOpened("STATEMENT " + this.m_stmt, this.m_isReadOnly);
        this.m_sqlStrList = new ArrayList();
        this.m_holder = new WeakReference<SStatementHolder>(holder);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.m_sqlStrList.add(sql);
        ResultSet result = this.m_stmt.executeQuery(sql);
        result = SResourceProxyFactory.getSResultSet(result, (SStatementHolder)this.m_holder.get());
        return result;
    }

    public int executeUpdate(String sql) throws SQLException {
        if (Debug.checkConstraints && this.m_isReadOnly) {
            String errMsg = "A read only statement is used for \"" + sql + "\"";
            throw new IllegalStateException(errMsg);
        }
        this.m_sqlStrList.add(sql);
        if (LockReleaseTracker.useTracker) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("STATEMENT = " + sql);
        }
        return this.m_stmt.executeUpdate(sql);
    }

    public void close() throws SQLException {
        SAdaptorStatement.logStatementClosed("STATEMENT " + this.m_stmt, this.m_isReadOnly);
        SStatementHolder holder = (SStatementHolder)this.m_holder.get();
        if (holder != null) {
            holder.removeStatement(this);
        }
        holder.checkResultSets();
        this.m_stmt.close();
    }

    public boolean execute(String sql) throws SQLException {
        this.m_sqlStrList.add(sql);
        return this.m_stmt.execute(sql);
    }

    public int hashCode() {
        return this.m_stmt.hashCode();
    }

    public boolean equals(Object o) {
        boolean result = false;
        Object obj = o;
        if (Proxy.isProxyClass(obj.getClass())) {
            obj = Proxy.getInvocationHandler(obj);
        }
        if (obj != null && obj instanceof SAdaptorStatement) {
            SAdaptorStatement sas = (SAdaptorStatement)obj;
            result = this.m_stmt.equals(sas.m_stmt);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("This statement has executed these statements:");
        Iterator elements = this.m_sqlStrList.iterator();
        while (elements.hasNext()) {
            result.append(" \"");
            result.append(elements.next());
            result.append("\", ");
        }
        return result.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        try {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                Object param = Array.get(args, 0);
                boolean tmpBoolean = this.equals(param);
                result = tmpBoolean ? Boolean.TRUE : Boolean.FALSE;
            } else if (methodName.equals("executeQuery")) {
                String sql = (String)Array.get(args, 0);
                result = this.executeQuery(sql);
            } else if (methodName.equals("executeUpdate")) {
                String sql = (String)Array.get(args, 0);
                int rows = this.executeUpdate(sql);
                result = new Integer(rows);
            } else if (methodName.equals("close")) {
                this.close();
                result = Void.TYPE;
            } else {
                String sql;
                boolean tmpBoolean;
                result = methodName.equals("execute") ? ((tmpBoolean = this.execute(sql = (String)Array.get(args, 0))) ? Boolean.TRUE : Boolean.FALSE) : (methodName.equals("toString") ? this.toString() : method.invoke((Object)this.m_stmt, args));
            }
        }
        catch (InvocationTargetException ex) {
            SQLException sqlExcp = null;
            Throwable t = ex.getTargetException();
            sqlExcp = t instanceof SQLException ? (SQLException)t : new SQLException(t.getMessage());
            throw sqlExcp;
        }
        catch (Throwable t) {
            throw t;
        }
        return result;
    }
}

