/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.LockReleaseTracker;
import com.cognos.jsmcommon.jdbc.SStatementHolder;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Iterator;
import java.util.WeakHashMap;

public final class SJDBCResourceContainer {
    private static SJDBCResourceContainer m_instance = new SJDBCResourceContainer();
    private WeakHashMap m_holders = new WeakHashMap(23);

    private SJDBCResourceContainer() {
    }

    public static synchronized SStatementHolder register(Object connection) {
        SStatementHolder holder = new SStatementHolder();
        if (SJDBCResourceContainer.m_instance.m_holders.put(connection, holder) != null) {
            String warMsg = "this connection is registered twice " + connection;
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(warMsg);
        }
        return holder;
    }

    public static synchronized void unregister(Object connection) {
        if (SJDBCResourceContainer.m_instance.m_holders.containsKey(connection)) {
            SStatementHolder holder = (SStatementHolder)SJDBCResourceContainer.m_instance.m_holders.remove(connection);
            if (LockReleaseTracker.useTracker && holder != null && !holder.isClosed()) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(holder.toString());
            }
        }
    }

    public static SJDBCResourceContainer getInstance() {
        return m_instance;
    }

    public SStatementHolder getHolder(Object connection) {
        SStatementHolder result = null;
        Object oneObj = SJDBCResourceContainer.m_instance.m_holders.get(connection);
        if (oneObj != null) {
            result = (SStatementHolder)oneObj;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator holders = this.m_holders.values().iterator();
        String newLine = System.getProperty("line.separator");
        while (holders.hasNext()) {
            result.append(holders.next());
            result.append(newLine);
        }
        return result.toString();
    }
}

