/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import java.lang.reflect.Array;

public final class SPSElement {
    private int m_index;
    private Object m_value;
    private int m_sqlType;
    private boolean m_sqlNull;

    SPSElement(int index, Object value) {
        this.m_index = index;
        this.m_value = value;
        this.m_sqlNull = false;
    }

    SPSElement(Object[] args, int length) {
        if (args == null || args.length < 2 && args.length > 3) {
            String errMsg = "constructing SPSElement with " + (args == null ? "no" : Integer.toString(args.length)) + " arguments is not supported";
            throw new IllegalStateException(errMsg);
        }
        this.m_sqlNull = false;
        if (args[0].getClass().isPrimitive()) {
            this.m_index = Array.getInt(args, 0);
        } else {
            Integer index = (Integer)args[0];
            this.m_index = index;
        }
        if (length == 2) {
            if (args[1].getClass().isPrimitive()) {
                this.m_sqlType = Array.getInt(args, 1);
                this.m_sqlNull = true;
            } else {
                this.m_value = args[1];
            }
        } else if (length == 3) {
            this.m_value = args[1].getClass().getName() + args[2];
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("index = ");
        result.append(this.m_index);
        if (this.m_sqlNull) {
            result.append(", null for type = ");
            result.append(this.m_sqlType);
        } else {
            result.append(", value = ");
            if (this.m_value != null) {
                result.append(this.m_value.getClass().getName());
                result.append("->");
            }
            result.append(this.m_value);
        }
        return result.toString();
    }
}

