/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.SAdaptorConnection;
import com.cognos.jsmcommon.jdbc.SAdaptorPreparedStatement;
import com.cognos.jsmcommon.jdbc.SAdaptorResultSet;
import com.cognos.jsmcommon.jdbc.SAdaptorStatement;
import com.cognos.jsmcommon.jdbc.SStatementHolder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class SResourceProxyFactory {
    public static Statement getSStatement(SStatementHolder holder, Statement stmt, boolean isReadOnly) {
        Statement result = null;
        SAdaptorStatement theHandler = new SAdaptorStatement(holder, stmt, isReadOnly);
        ClassLoader sqlCL = stmt.getClass().getClassLoader();
        if (sqlCL == null) {
            sqlCL = ClassLoader.getSystemClassLoader();
        }
        result = (Statement)Proxy.newProxyInstance(sqlCL, new Class[]{Statement.class}, (InvocationHandler)theHandler);
        return result;
    }

    public static PreparedStatement getSPreparedStatement(SStatementHolder holder, String sqlStr, PreparedStatement ps, boolean isReadOnly) {
        PreparedStatement result = null;
        SAdaptorPreparedStatement theHandler = new SAdaptorPreparedStatement(holder, sqlStr, ps, isReadOnly);
        ClassLoader sqlCL = ps.getClass().getClassLoader();
        if (sqlCL == null) {
            sqlCL = ClassLoader.getSystemClassLoader();
        }
        result = (PreparedStatement)Proxy.newProxyInstance(sqlCL, new Class[]{PreparedStatement.class}, (InvocationHandler)theHandler);
        return result;
    }

    public static ResultSet getSResultSet(ResultSet realRS, SStatementHolder holder) throws SQLException {
        ResultSet result = null;
        SAdaptorResultSet theHandler = new SAdaptorResultSet(realRS, holder);
        ClassLoader sqlCL = realRS.getClass().getClassLoader();
        if (sqlCL == null) {
            sqlCL = ClassLoader.getSystemClassLoader();
        }
        Class rsClass = ResultSet.class;
        try {
            rsClass = sqlCL.loadClass("oracle.jdbc.internal.OracleResultSet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        result = (ResultSet)Proxy.newProxyInstance(sqlCL, new Class[]{rsClass}, (InvocationHandler)theHandler);
        return result;
    }

    public static Connection getSConnection(Connection realConnection, boolean readOnly) throws SQLException {
        Connection result = null;
        SAdaptorConnection theHandler = new SAdaptorConnection(readOnly, realConnection);
        ClassLoader sqlCL = realConnection.getClass().getClassLoader();
        if (sqlCL == null) {
            sqlCL = ClassLoader.getSystemClassLoader();
        }
        result = (Connection)Proxy.newProxyInstance(sqlCL, new Class[]{Connection.class}, (InvocationHandler)theHandler);
        return result;
    }
}

