/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc;

import com.cognos.jsmcommon.jdbc.LockReleaseTracker;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public final class SStatementHolder {
    private Map m_preparedStatements;
    private Map m_statements = new HashMap();
    private Map m_resultSets;

    SStatementHolder() {
        this.m_preparedStatements = new HashMap();
        this.m_resultSets = new HashMap();
    }

    void addStatement(Statement stmt) {
        if (stmt != null) {
            this.m_statements.put(stmt, new ResourceStack(stmt));
        }
    }

    void addPrepearedStatement(PreparedStatement ps) {
        if (ps != null) {
            this.m_preparedStatements.put(ps, new ResourceStack(ps));
        }
    }

    void removePreparedStatement(Object ps) {
        if (this.m_preparedStatements.remove(ps) == null) {
            String errMsg = "PREPARED STATEMENT, \"" + ps + "\" is not in the holder to be removed";
            throw new IllegalStateException(errMsg);
        }
    }

    void removeStatement(Object stmt) {
        if (this.m_statements.remove(stmt) == null) {
            String errMsg = "STATEMENT, \"" + stmt + "\" is not in the holder to be removed";
            throw new IllegalStateException(errMsg);
        }
    }

    void addResultSet(ResultSet set) {
        this.m_resultSets.put(set, new ResourceStack(set));
    }

    void removeResultSet(Object set) {
        this.m_resultSets.remove(set);
    }

    private void closeStatements(Map map) {
        ResourceStack[] openStatements = map.values().toArray(new ResourceStack[0]);
        for (int counter = 0; counter < openStatements.length; ++counter) {
            try {
                ((Statement)openStatements[counter].resource).close();
                continue;
            }
            catch (Throwable t) {
                openStatements[counter] = null;
            }
        }
        map.clear();
    }

    private void closeresultSets(Map map) {
        ResourceStack[] openStatements = map.values().toArray(new ResourceStack[0]);
        for (int counter = 0; counter < openStatements.length; ++counter) {
            try {
                ((ResultSet)openStatements[counter].resource).close();
                continue;
            }
            catch (Throwable t) {
                openStatements[counter] = null;
            }
        }
        map.clear();
    }

    public boolean isClosed() {
        return this.m_statements.isEmpty() && this.m_preparedStatements.isEmpty() && this.m_resultSets.isEmpty();
    }

    public void checkResultSets() {
        StringBuffer result = new StringBuffer();
        if (!this.m_resultSets.isEmpty()) {
            result.append(this.m_resultSets.size());
            result.append(" RESULT SET objects are not closed.\n");
            result.append("allocated at: " + this.getStacks(this.m_resultSets));
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(result.toString());
        }
    }

    public void freeResources() {
        if (!LockReleaseTracker.useTracker) {
            return;
        }
        StringBuffer result = new StringBuffer();
        if (!this.m_statements.isEmpty()) {
            result.append(this.m_statements.size());
            result.append(" STATEMENT objects are not closed\n");
            result.append("allocated at: " + this.getStacks(this.m_statements));
            this.closeStatements(this.m_statements);
            this.m_statements.clear();
        }
        if (!this.m_preparedStatements.isEmpty()) {
            result.append(this.m_preparedStatements.size());
            result.append(" PREPARED STATEMENT objects are not closed.\n");
            result.append("allocated at: " + this.getStacks(this.m_preparedStatements));
            this.closeStatements(this.m_preparedStatements);
            this.m_preparedStatements.clear();
        }
        if (!this.m_resultSets.isEmpty()) {
            result.append(this.m_resultSets.size());
            result.append(" RESULT SET objects are not closed.\n");
            result.append("allocated at: " + this.getStacks(this.m_resultSets));
            this.closeStatements(this.m_resultSets);
            this.m_resultSets.clear();
        }
        if (result.length() > 0) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(result.toString());
        }
    }

    private String getStacks(Map statements) {
        String stacks = "";
        ResourceStack[] openStatements = statements.values().toArray(new ResourceStack[0]);
        for (int counter = 0; counter < openStatements.length; ++counter) {
            stacks = stacks + openStatements[counter].toString();
        }
        return stacks;
    }

    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        Object oneObj2 = null;
        for (Object oneObj2 : this.m_statements.values()) {
            result.append((Object)oneObj2);
            result.append(newLine);
        }
        for (Object oneObj2 : this.m_preparedStatements.values()) {
            result.append((Object)oneObj2);
            result.append(newLine);
        }
        for (Object oneObj2 : this.m_resultSets.values()) {
            result.append((Object)oneObj2);
            result.append(newLine);
        }
        return result.toString();
    }

    private class ResourceStack {
        public Throwable throwable;
        public Object resource;

        public ResourceStack(Object stmt, Throwable t) {
            this.resource = stmt;
            this.throwable = t;
        }

        public ResourceStack(Object stmt) {
            this.resource = stmt;
            this.throwable = new Exception().fillInStackTrace();
        }

        public boolean equals(Object obj) {
            return this.resource.equals(obj);
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        public String toString() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            ps.println(this.resource + " allocated at: ");
            this.throwable.printStackTrace(ps);
            ps.flush();
            String stacks = "";
            try {
                stacks = baos.toString("UTF-8");
                ps.close();
                baos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stacks;
        }
    }
}

