/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.property.CMProperties;
import java.util.Properties;

public class DB2Properties
extends JDBCConnectionProperties {
    private String mUrl;
    private final String mDriver = "com.ibm.db2.jcc.DB2Driver";
    private final int mFetchSize = 10;
    private final boolean mKeepOpen = true;
    private final DatabaseType mDbType = DatabaseType.DB2;
    private final String mCheckConnectionStatement = "SELECT CURRENT SERVER FROM SYSIBM.SYSDUMMY1";

    protected DB2Properties(CMProperties cmProps) throws ConnectionException {
        super(cmProps);
        Properties props = cmProps.getProperties();
        String serverPort = props.getProperty("server");
        String dbNAme = props.getProperty("name");
        this.mUrl = serverPort == null || serverPort.trim().length() == 0 ? "jdbc:db2:" + dbNAme : "jdbc:db2://" + serverPort + "/" + dbNAme;
        boolean dbEncrypt = Boolean.parseBoolean(props.getProperty("SSLencryptionEnabled"));
        if (dbEncrypt) {
            this.mUrl = this.mUrl + ":sslConnection=true;";
        }
        if (props.containsKey("securityMechanism")) {
            this.mUrl = this.mUrl + ":securityMechanism=" + props.getProperty("securityMechanism") + ";";
        }
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return "SELECT CURRENT SERVER FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public DatabaseType getDBType() {
        return this.mDbType;
    }

    @Override
    public String getDriverStr() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public int getFetchSize() {
        return 10;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return true;
    }

    @Override
    public boolean getKeepOpen() {
        return true;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }
}

