/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.property.CMProperties;
import java.util.Properties;

public class DerbyProperties
extends JDBCConnectionProperties {
    private final String mUrl;
    private final String mDriver = "org.apache.derby.jdbc.ClientDriver";
    private final int mFetchSize = 10;
    private final boolean mKeepOpen = true;
    private final DatabaseType mDbType = DatabaseType.DERBY;
    private final String mCheckConnectionStatement = "SELECT 'A' FROM (VALUES 1) qq";

    protected DerbyProperties(CMProperties cmProps) throws ConnectionException {
        super(cmProps);
        Properties props = cmProps.getProperties();
        String serverName = props.getProperty("server");
        this.mUrl = serverName == null || serverName.length() < 1 ? "jdbc:derby://localhost:1527/" + props.getProperty("name") : "jdbc:derby://" + serverName + "/" + props.getProperty("name");
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return "SELECT 'A' FROM (VALUES 1) qq";
    }

    @Override
    public DatabaseType getDBType() {
        return this.mDbType;
    }

    @Override
    public String getDriverStr() {
        return "org.apache.derby.jdbc.ClientDriver";
    }

    @Override
    public int getFetchSize() {
        return 10;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return false;
    }

    @Override
    public boolean getKeepOpen() {
        return true;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }
}

