/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.PropertiesException;

public class HSQLProperties
extends JDBCConnectionProperties {
    private String mUrl = "jdbc:hsqldb:mem:notificationDB;shutdown=true";
    private String mDriver = "org.hsqldb.jdbcDriver";
    private int mFetchSize = 1000000;
    private boolean mKeepOpen = true;
    private final DatabaseType mDbType = DatabaseType.HSQL;
    private String mCheckConnectionStatement = "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS WHERE 1=0";

    protected HSQLProperties(CMProperties props) throws ConnectionException {
        super(props);
        try {
            String dbName = "";
            if (props != null) {
                dbName = props.getProperty("name");
            }
            if (dbName != null && !"".equals(dbName)) {
                this.mUrl = "jdbc:hsqldb:file:" + props.getProperty("name") + ";shutdown=true";
            }
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return this.mCheckConnectionStatement;
    }

    @Override
    public DatabaseType getDBType() {
        return this.mDbType;
    }

    @Override
    public String getDriverStr() {
        return this.mDriver;
    }

    @Override
    public int getFetchSize() {
        return this.mFetchSize;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return true;
    }

    @Override
    public boolean getKeepOpen() {
        return this.mKeepOpen;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }

    @Override
    public String getShutdownCommand() {
        return "SHUTDOWN COMPACT";
    }
}

