/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.property.CMProperties;
import java.util.Properties;

public class InformixProperties
extends JDBCConnectionProperties {
    private String mUrl;
    private final String mDriver = "com.ibm.db2.jcc.DB2Driver";
    private final int mFetchSize = 10;
    private final boolean mKeepOpen = true;
    private String mCheckConnectionStatement = "SELECT 1 FROM NC_CTMAP";

    protected InformixProperties(CMProperties cmProps, String component) throws ConnectionException {
        super(cmProps);
        Properties props = cmProps.getProperties();
        String serverName = props.getProperty("server");
        String dbNAme = props.getProperty("name");
        this.mUrl = serverName == null || serverName.trim().length() == 0 ? "jdbc:db2://" + dbNAme : "jdbc:db2://" + serverName + "/" + dbNAme;
        this.mUrl = this.mUrl + ":retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=false;";
        boolean dbEncrypt = Boolean.parseBoolean(props.getProperty("SSLencryptionEnabled"));
        if (dbEncrypt) {
            StringBuffer tmp = new StringBuffer(this.mUrl);
            tmp.append("sslConnection=true;");
            this.mUrl = tmp.toString();
        }
        if ("HTS".equals(component)) {
            this.mCheckConnectionStatement = "SELECT 1 FROM informix.systables";
        }
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return this.mCheckConnectionStatement;
    }

    @Override
    public DatabaseType getDBType() {
        return DatabaseType.INFORMIX;
    }

    @Override
    public String getDriverStr() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public int getFetchSize() {
        return 10;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return true;
    }

    @Override
    public boolean getKeepOpen() {
        return true;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }
}

