/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.HSQLProperties;
import com.cognos.jsmcommon.jdbc.props.PropsFactory;
import com.cognos.jsmcommon.jdbc.props.ServerPropsFactory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.HTSCnfgProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public abstract class JDBCConnectionProperties {
    protected static final String DB2 = "DB2";
    protected static final String MSSQL = "Microsoft";
    protected static final String MSSQLWINAUTH = "MicrosoftWinAuth";
    protected static final String ORACLE = "Oracle";
    protected static final String ORACLE_ADV = "OracleAdvanced";
    protected static final String SYBASE = "Sybase";
    protected static final String DERBY = "Derby";
    protected static final String INFORMIX = "Informix";
    protected static final String DUMMY = "Dummy";
    protected static final String HSQLDB = "HyperSQL";
    private TokenWriter m_token_writer = new GenericTokenWriter();
    private String mLogId = null;
    private String mPassword = null;
    private static Integer UNLIMITED = -1;
    private Integer mMaxConnections = UNLIMITED;
    private Integer mMaxReadOnlyConnections = UNLIMITED;
    private boolean mUseTrackerObjects = false;
    private static JDBCConnectionProperties mInstance = null;
    private static JDBCConnectionProperties mInstanceHTS = null;
    protected static PropsFactory m_factory = new ServerPropsFactory();

    public abstract String getDriverStr();

    public abstract boolean getKeepOpen();

    public abstract String getUrlStr();

    public abstract int getFetchSize();

    public abstract DatabaseType getDBType();

    protected abstract String getDefaultCheckConnectionStatement();

    public String getCheckConnectionStatement() {
        String result = this.getDefaultCheckConnectionStatement();
        try {
            String str = CRNProperties.getInstance().getProperty("emf.connection.sql.statement");
            if (str != null && str.trim().length() > 0) {
                result = str;
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, ex);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return result;
    }

    public abstract boolean shouldSetFetchSize();

    public int getReadOnlyIsolationLevel() {
        return 1;
    }

    public int getReadWriteIsolationLevel() {
        return 1;
    }

    public String getLogId() {
        return this.mLogId;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public Integer getMaxConnections() {
        try {
            String str = this.getAdvancedPropertyForService("connection.write.maxConnections");
            if (str != null && str.trim().length() > 0) {
                this.mMaxConnections = Integer.valueOf(str);
            }
        }
        catch (PropertiesException propertiesException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.mMaxConnections;
    }

    public Integer getMaxReadOnlyConnections() {
        try {
            String str = this.getAdvancedPropertyForService("connection.read.maxConnections");
            if (str != null && str.trim().length() > 0) {
                this.mMaxReadOnlyConnections = Integer.valueOf(str);
            }
        }
        catch (PropertiesException propertiesException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.mMaxReadOnlyConnections;
    }

    public void setMaxReadHTSConnections() {
        this.mMaxReadOnlyConnections = new Integer(5);
        try {
            String str = CRNProperties.getInstance().getProperty("connection.maxHTSConnections");
            if (str != null && str.trim().length() > 0) {
                this.mMaxReadOnlyConnections = Integer.valueOf(str);
            }
        }
        catch (PropertiesException propertiesException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean getUseTracker() {
        try {
            String str = CRNProperties.getInstance().getProperty("connection.tracker.use");
            if (str != null && str.trim().length() > 0) {
                this.mUseTrackerObjects = Boolean.valueOf(str);
            }
        }
        catch (PropertiesException propertiesException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.mUseTrackerObjects;
    }

    protected JDBCConnectionProperties(CMProperties cmProps) throws ConnectionException {
        String jsmJDBC_driver = null;
        try {
            jsmJDBC_driver = CRNProperties.getInstance().getProperty("jsm.jdbc.driver");
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(ex);
        }
        Properties theProps = null;
        if (cmProps != null && (theProps = cmProps.getProperties()) != null) {
            if (jsmJDBC_driver != null && jsmJDBC_driver.trim().length() > 0) {
                theProps.put("jdbc.driver", jsmJDBC_driver);
            }
            this.mLogId = theProps.getProperty("username");
            this.mPassword = theProps.getProperty("password");
        }
    }

    public static void resetInstance() {
        mInstance = null;
        mInstanceHTS = null;
    }

    public static JDBCConnectionProperties testInstance(CMProperties cmProperties) throws ConnectionException {
        return JDBCConnectionProperties.loadType(cmProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JDBCConnectionProperties instance() {
        if (mInstance != null) return mInstance;
        Class<JDBCConnectionProperties> clazz = JDBCConnectionProperties.class;
        synchronized (JDBCConnectionProperties.class) {
            if (mInstance == null) {
                try {
                    mInstance = JDBCConnectionProperties.loadType(CMProperties.getInstance(), null);
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Database Type is: " + mInstance.getDBType().toString());
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Connection URL is: " + mInstance.getUrlStr());
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Driver is: " + mInstance.getDriverStr());
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Log id is: " + mInstance.getLogId());
                }
                catch (ConnectionException ex) {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("Failed to read JDBC connection properties.");
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, ex);
                }
            } else {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("No data store connection properties could be found.");
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_CONFIG_PROPERTY_EXCP, new String[]{"contentManager"});
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void setInstance(JDBCConnectionProperties instance, String component) throws ConnectionException {
        if (component == null) {
            mInstance = instance;
        } else if ("HTS".equals(component)) {
            mInstanceHTS = instance;
        }
    }

    public static void setInstanceInMemoryDb() throws ConnectionException {
        mInstanceHTS = mInstance = new HSQLProperties(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JDBCConnectionProperties instance(String component) {
        if (component == null || "SDS".equals(component)) {
            return JDBCConnectionProperties.instance();
        }
        if (!"HTS".equals(component)) return null;
        if (mInstanceHTS != null) return mInstanceHTS;
        Class<JDBCConnectionProperties> clazz = JDBCConnectionProperties.class;
        synchronized (JDBCConnectionProperties.class) {
            if (mInstanceHTS == null) {
                try {
                    HTSCnfgProperties cnfg = HTSCnfgProperties.getInstance();
                    cnfg.init(CCLConfigurationFactory.getInstance());
                    mInstanceHTS = JDBCConnectionProperties.loadType(cnfg, component);
                    mInstanceHTS.setMaxReadHTSConnections();
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Database for " + component + " Type is: " + mInstanceHTS.getDBType().toString());
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Connection for " + component + " URL is: " + mInstanceHTS.getUrlStr());
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Driver for " + component + " is: " + mInstanceHTS.getDriverStr());
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Log id for " + component + " is: " + mInstanceHTS.getLogId());
                }
                catch (ConnectionException ex) {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("Failed to read JDBC connection properties for " + component + ".");
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, ex);
                }
            } else {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("No data store connection properties could be found.");
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_CONFIG_PROPERTY_EXCP, new String[]{"contentManager"});
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstanceHTS;
        }
    }

    private static JDBCConnectionProperties loadType(CMProperties cmProperties, String component) throws ConnectionException {
        return m_factory.getProperties(cmProperties, component);
    }

    public int getMessageTokenLength() {
        return 1500;
    }

    public TokenWriter getTokenWriter() {
        return this.m_token_writer;
    }

    public String getShutdownCommand() {
        return null;
    }

    private String getAdvancedPropertyForService(String key) throws PropertiesException {
        CRNProperties.ServiceNames.ServiceKey[] serviceKeys = mInstanceHTS == this ? new CRNProperties.ServiceNames.ServiceKey[]{CRNProperties.ServiceNames.ServiceKey.HUMAN} : new CRNProperties.ServiceNames.ServiceKey[]{CRNProperties.ServiceNames.ServiceKey.MONITOR, CRNProperties.ServiceNames.ServiceKey.DELIVERY, CRNProperties.ServiceNames.ServiceKey.EVENT, CRNProperties.ServiceNames.ServiceKey.JOB, null};
        return CRNProperties.getInstance().getAdvancedProperty(serviceKeys, key);
    }

    public class GenericTokenWriter
    implements TokenWriter {
        @Override
        public String readToken(ResultSet rs, String column) throws SQLException {
            return rs.getString(column);
        }

        @Override
        public String readToken(ResultSet rs, int column) throws SQLException {
            return rs.getString(column);
        }

        @Override
        public void writeToken(PreparedStatement ps, int index, String token) throws SQLException {
            ps.setString(index, token);
        }
    }

    public static interface TokenWriter {
        public void writeToken(PreparedStatement var1, int var2, String var3) throws SQLException;

        public String readToken(ResultSet var1, String var2) throws SQLException;

        public String readToken(ResultSet var1, int var2) throws SQLException;
    }
}

