/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Properties;

public class MicrosoftSQLProperties
extends JDBCConnectionProperties {
    private String mUrl = null;
    private String mDriver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private int mFetchSize = 1000000;
    private boolean mKeepOpen = true;
    private final DatabaseType mDbType = DatabaseType.MSSQL;
    private String mCheckConnectionStatement = "select 1";
    private String m_encStr = "";

    protected MicrosoftSQLProperties(CMProperties cmProps) throws ConnectionException {
        super(cmProps);
        StringBuffer tmp;
        Properties ncDbProps = new Properties();
        Properties props = cmProps.getProperties();
        try {
            String dbInfoFile = CCLConfigurationUtils.resolveEffectivePath((String)"../configuration/ncdbinfo.properties");
            ncDbProps = cmProps.getProperties(dbInfoFile);
            Properties printableNcDbProps = (Properties)ncDbProps.clone();
            printableNcDbProps.remove("password");
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("MicrosoftSQLProperties: ncdbinfo.properties found " + printableNcDbProps);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("MicrosoftSQLProperties: ncdbinfo.properties Not found ");
        }
        String jdbcDriver = ncDbProps.getProperty("jdbc.driver", this.mDriver);
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("MicrosoftSQLProperties: jdbcDriver property found -[" + jdbcDriver + "]");
        if (this.mDriver.compareTo(jdbcDriver) == 0) {
            this.mUrl = "jdbc:sqlserver://" + props.getProperty("server") + ";databasename=" + props.getProperty("name") + ";selectMethod=cursor";
            this.m_encStr = ";encrypt=true;trustServerCertificate=true";
        } else {
            this.mUrl = "jdbc:JSQLConnect://" + props.getProperty("server") + "/" + props.getProperty("name");
            this.mDriver = jdbcDriver;
            this.m_encStr = ";ssl=manual";
        }
        boolean dbEncrypt = Boolean.parseBoolean(props.getProperty("SSLencryptionEnabled"));
        if (dbEncrypt) {
            tmp = new StringBuffer(this.mUrl);
            tmp.append(this.m_encStr);
            this.mUrl = tmp.toString();
        }
        tmp = new StringBuffer(this.mUrl);
        if (props.containsKey("encrypt")) {
            tmp.append(";encrypt=" + props.getProperty("encrypt"));
        }
        if (props.containsKey("trustServerCertificate")) {
            tmp.append(";trustServerCertificate=" + props.getProperty("trustServerCertificate"));
        }
        this.mUrl = tmp.toString();
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return this.mCheckConnectionStatement;
    }

    @Override
    public DatabaseType getDBType() {
        return this.mDbType;
    }

    @Override
    public String getDriverStr() {
        return this.mDriver;
    }

    @Override
    public int getFetchSize() {
        return this.mFetchSize;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return true;
    }

    @Override
    public boolean getKeepOpen() {
        return this.mKeepOpen;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }
}

