/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Properties;

public class MicrosoftWinAuthProperties
extends JDBCConnectionProperties {
    private String mUrl = null;
    private String mDriver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private int mFetchSize = 1000000;
    private boolean mKeepOpen = true;
    private DatabaseType mDbType = DatabaseType.MSSQL;
    private String mCheckConnectionStatement = "select 1";
    private String m_encStr = "";

    protected MicrosoftWinAuthProperties(CMProperties cmProps) throws ConnectionException {
        super(cmProps);
        Properties ncDbProps = new Properties();
        Properties props = cmProps.getProperties();
        try {
            String dbInfoFile = CCLConfigurationUtils.resolveEffectivePath((String)"../configuration/ncdbinfo.properties");
            ncDbProps = cmProps.getProperties(dbInfoFile);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("MicrosoftWinAuthProperties: ncdbinfo.properties found " + ncDbProps);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("MicrosoftWinAuthProperties: ncdbinfo.properties Not found ");
        }
        String jdbcDriver = ncDbProps.getProperty("jdbc.driver", this.mDriver);
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("MicrosoftWinAuthProperties: jdbcDriver property found -[" + jdbcDriver + "]");
        if (this.mDriver.compareTo(jdbcDriver) == 0) {
            this.mUrl = "jdbc:sqlserver://" + props.getProperty("server") + ";databasename=" + props.getProperty("name") + ";integratedSecurity=true" + ";selectMethod=cursor";
            this.m_encStr = ";encrypt=true;trustServerCertificate=true";
        } else {
            this.mUrl = "jdbc:JSQLConnect://" + props.getProperty("server") + "/" + props.getProperty("name") + "/trustedAuthentication=true";
            this.mDriver = jdbcDriver;
            this.m_encStr = ";ssl=manual";
        }
        boolean dbEncrypt = Boolean.parseBoolean(props.getProperty("SSLencryptionEnabled"));
        if (dbEncrypt) {
            StringBuffer tmp = new StringBuffer(this.mUrl);
            tmp.append(this.m_encStr);
            this.mUrl = tmp.toString();
        }
        this.mDriver = jdbcDriver;
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return this.mCheckConnectionStatement;
    }

    @Override
    public DatabaseType getDBType() {
        return this.mDbType;
    }

    @Override
    public String getDriverStr() {
        return this.mDriver;
    }

    @Override
    public int getFetchSize() {
        return this.mFetchSize;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return true;
    }

    @Override
    public boolean getKeepOpen() {
        return this.mKeepOpen;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }
}

