/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

public final class OracleProperties
extends JDBCConnectionProperties {
    private String mUrl;
    private final String mDriver = "oracle.jdbc.OracleDriver";
    private final String mOraclePKIProvider = "oracle.security.pki.OraclePKIProvider";
    private final int mFetchSize = 10;
    private boolean mKeepOpen = true;
    private final DatabaseType mDbType = DatabaseType.ORACLE;
    private final String mCheckConnectionStatement = "select 1 from DUAL";

    protected OracleProperties(CMProperties cmProps, String dbType) throws ConnectionException {
        super(cmProps);
        Properties props = cmProps.getProperties();
        if ("Oracle".equalsIgnoreCase(dbType)) {
            String service = props.getProperty("servicename");
            this.mUrl = "jdbc:oracle:thin:@" + props.getProperty("server") + ":" + service;
        } else if ("OracleAdvanced".equalsIgnoreCase(dbType)) {
            String dbspecifier = "";
            try {
                dbspecifier = cmProps.getProperty("specifier");
            }
            catch (PropertiesException e) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, e);
                throw new ConnectionException(I18NCode.MSG_CONFIG_PROPERTY_EXCP, new Object[]{"specifier"}, e);
            }
            this.mUrl = "jdbc:oracle:thin:@" + dbspecifier;
        } else {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("Encountered unknown Oracle type [" + dbType + "].");
            throw new ConnectionException(I18NCode.MSG_CONFIG_PROPERTY_EXCP, new Object[]{dbType});
        }
        boolean dbEncrypt = Boolean.parseBoolean(props.getProperty("SSLencryptionEnabled"));
        if (dbEncrypt) {
            this.addOraclePKIProvider();
        }
        try {
            String str = CRNProperties.getInstance().getProperty("connection.use.pool");
            if (str != null && str.trim().length() > 0) {
                this.mKeepOpen = Boolean.valueOf(str);
            }
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(e);
        }
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return "select 1 from DUAL";
    }

    @Override
    public DatabaseType getDBType() {
        return this.mDbType;
    }

    @Override
    public String getDriverStr() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public int getFetchSize() {
        return 10;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return true;
    }

    @Override
    public boolean getKeepOpen() {
        return this.mKeepOpen;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }

    @Override
    public int getReadWriteIsolationLevel() {
        return 2;
    }

    @Override
    public int getReadOnlyIsolationLevel() {
        return 2;
    }

    private void addOraclePKIProvider() {
        try {
            String oraclePKIProviderClassPath = "oracle.security.pki.OraclePKIProvider";
            Security.addProvider((Provider)Class.forName(oraclePKIProviderClassPath).newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

