/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DB2Properties;
import com.cognos.jsmcommon.jdbc.props.DerbyProperties;
import com.cognos.jsmcommon.jdbc.props.HSQLProperties;
import com.cognos.jsmcommon.jdbc.props.InformixProperties;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.props.MicrosoftSQLProperties;
import com.cognos.jsmcommon.jdbc.props.MicrosoftWinAuthProperties;
import com.cognos.jsmcommon.jdbc.props.OracleProperties;
import com.cognos.jsmcommon.jdbc.props.PropsFactory;
import com.cognos.jsmcommon.jdbc.props.SybaseProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Properties;

public final class ServerPropsFactory
extends PropsFactory {
    @Override
    public JDBCConnectionProperties getProperties(CMProperties cmProperties, String component) throws ConnectionException {
        JDBCConnectionProperties jdbcProps = null;
        Properties props = cmProperties.getProperties();
        if (!this.propertiesUnset(cmProperties) && props != null) {
            String strType = props.getProperty("databaseType");
            if ("DB2".equalsIgnoreCase(strType)) {
                jdbcProps = new DB2Properties(cmProperties);
            } else if ("Microsoft".equalsIgnoreCase(strType)) {
                jdbcProps = new MicrosoftSQLProperties(cmProperties);
            } else if ("MicrosoftWinAuth".equalsIgnoreCase(strType)) {
                jdbcProps = new MicrosoftWinAuthProperties(cmProperties);
            } else if ("Sybase".equalsIgnoreCase(strType)) {
                jdbcProps = new SybaseProperties(cmProperties);
            } else if ("Derby".equalsIgnoreCase(strType)) {
                jdbcProps = new DerbyProperties(cmProperties);
            } else if ("Oracle".equalsIgnoreCase(strType) || "OracleAdvanced".equalsIgnoreCase(strType)) {
                jdbcProps = new OracleProperties(cmProperties, strType);
            } else if ("Informix".equalsIgnoreCase(strType)) {
                jdbcProps = new InformixProperties(cmProperties, component);
            } else if ("HyperSQL".equalsIgnoreCase(strType)) {
                jdbcProps = new HSQLProperties(cmProperties);
            } else {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.FATAL, new Exception("Encountered unknown database type [" + strType + "]. Unable to configure connection properties."));
                throw new ConnectionException(I18NCode.MSG_CONFIG_PROPERTY_EXCP, new Object[]{strType});
            }
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("JDBCConnectionProperties jdbcDriver url:" + jdbcProps.getUrlStr());
            ServerPropsFactory.logtoCogserver("JDBCConnectionProperties jdbcDriver url:" + jdbcProps.getUrlStr(), null);
        }
        return jdbcProps;
    }

    private static void logtoCogserver(String msg, Exception e) {
        try {
            AuditProperties props = new AuditProperties("Run", msg, "", "Run");
            if (e != null) {
                props = new AuditProperties("Run", msg, e.getMessage(), "Run");
            }
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, props);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean propertiesUnset(CMProperties props) throws ConnectionException {
        boolean unset = false;
        String strType = null;
        try {
            String serverPort = props.getProperty("server");
            String dbName = props.getProperty("name");
            String dbSpecifier = props.getProperty("specifier");
            strType = props.getProperty("databaseType");
            if (!"HyperSQL".equalsIgnoreCase(strType)) {
                unset = serverPort == null || "".equals(serverPort);
                unset = unset && dbName == null || "".equals(dbName);
                unset = unset && dbSpecifier == null || "".equals(dbSpecifier);
            }
        }
        catch (PropertiesException e) {
            throw new ConnectionException(I18NCode.MSG_CONFIG_PROPERTY_EXCP, new Object[]{strType});
        }
        return unset;
    }
}

